/* poppler-glib.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Poppler", gir_namespace = "Poppler", gir_version = "0.18", lower_case_cprefix = "poppler_")]
namespace Poppler {
	namespace AnnotTextIcon {
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_CIRCLE")]
		public const string CIRCLE;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_COMMENT")]
		public const string COMMENT;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_CROSS")]
		public const string CROSS;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_HELP")]
		public const string HELP;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_INSERT")]
		public const string INSERT;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_KEY")]
		public const string KEY;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_NEW_PARAGRAPH")]
		public const string NEW_PARAGRAPH;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_NOTE")]
		public const string NOTE;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_PARAGRAPH")]
		public const string PARAGRAPH;
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_action_get_type ()")]
	[Compact]
	public class Action {
		public Poppler.ActionAny any;
		public Poppler.ActionGotoDest goto_dest;
		public Poppler.ActionGotoRemote goto_remote;
		public Poppler.ActionJavascript javascript;
		public Poppler.ActionLaunch launch;
		public Poppler.ActionMovie movie;
		public Poppler.ActionNamed named;
		public Poppler.ActionOCGState ocg_state;
		public Poppler.ActionRendition rendition;
		public Poppler.ActionType type;
		public Poppler.ActionUri uri;
		public Poppler.Action copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_get_type ()")]
	public class Annot : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Annot ();
		public Poppler.AnnotType get_annot_type ();
		public Poppler.Color get_color ();
		public string get_contents ();
		public Poppler.AnnotFlag get_flags ();
		public string get_modified ();
		public string get_name ();
		public int get_page_index ();
		public void set_color (Poppler.Color? poppler_color);
		public void set_contents (string contents);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_annot_callout_line_get_type ()")]
	[Compact]
	public class AnnotCalloutLine {
		public bool multiline;
		public double x1;
		public double x2;
		public double x3;
		public double y1;
		public double y2;
		public double y3;
		[CCode (has_construct_function = false)]
		public AnnotCalloutLine ();
		public Poppler.AnnotCalloutLine copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_file_attachment_get_type ()")]
	public class AnnotFileAttachment : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false)]
		protected AnnotFileAttachment ();
		public Poppler.Attachment get_attachment ();
		public string get_name ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_free_text_get_type ()")]
	public class AnnotFreeText : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false)]
		protected AnnotFreeText ();
		public Poppler.AnnotCalloutLine get_callout_line ();
		public Poppler.AnnotFreeTextQuadding get_quadding ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_annot_mapping_get_type ()")]
	[Compact]
	public class AnnotMapping {
		public Poppler.Annot annot;
		public Poppler.Rectangle area;
		[CCode (has_construct_function = false)]
		public AnnotMapping ();
		public Poppler.AnnotMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_markup_get_type ()")]
	public class AnnotMarkup : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotMarkup ();
		public GLib.Date get_date ();
		public Poppler.AnnotExternalDataType get_external_data ();
		public string get_label ();
		public double get_opacity ();
		public bool get_popup_is_open ();
		public bool get_popup_rectangle (out Poppler.Rectangle poppler_rect);
		public Poppler.AnnotMarkupReplyType get_reply_to ();
		public string get_subject ();
		public bool has_popup ();
		public void set_label (string? label);
		public void set_opacity (double opacity);
		public void set_popup (Poppler.Rectangle popup_rect);
		public void set_popup_is_open (bool is_open);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_movie_get_type ()")]
	public class AnnotMovie : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotMovie ();
		public unowned Poppler.Movie get_movie ();
		public string get_title ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_screen_get_type ()")]
	public class AnnotScreen : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotScreen ();
		public unowned Poppler.Action get_action ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_text_get_type ()")]
	public class AnnotText : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		public AnnotText (Poppler.Document doc, Poppler.Rectangle rect);
		public string get_icon ();
		public bool get_is_open ();
		public Poppler.AnnotTextState get_state ();
		public void set_icon (string icon);
		public void set_is_open (bool is_open);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_attachment_get_type ()")]
	public class Attachment : GLib.Object {
		public GLib.StringBuilder checksum;
		public GLib.Time ctime;
		public string description;
		public GLib.Time mtime;
		public string name;
		public size_t size;
		[CCode (has_construct_function = false)]
		protected Attachment ();
		public bool save (string filename) throws GLib.Error;
		public bool save_to_callback (Poppler.AttachmentSaveFunc save_func) throws GLib.Error;
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_color_get_type ()")]
	[Compact]
	public class Color {
		public uint16 blue;
		public uint16 green;
		public uint16 red;
		[CCode (has_construct_function = false)]
		public Color ();
		public Poppler.Color copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_dest_get_type ()")]
	[Compact]
	public class Dest {
		public double bottom;
		public uint change_left;
		public uint change_top;
		public uint change_zoom;
		public double left;
		public string named_dest;
		public int page_num;
		public double right;
		public double top;
		public Poppler.DestType type;
		public double zoom;
		public Poppler.Dest copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_document_get_type ()")]
	public class Document : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Document ();
		public Poppler.Dest find_dest (string link_name);
		[CCode (has_construct_function = false)]
		public Document.from_data (string data, int length, string? password) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Document.from_file (string uri, string? password) throws GLib.Error;
		public GLib.List<Poppler.Attachment> get_attachments ();
		public string get_author ();
		public long get_creation_date ();
		public string get_creator ();
		public Poppler.FormField get_form_field (int id);
		public bool get_id (out string permanent_id, out string update_id);
		public string get_keywords ();
		public string get_metadata ();
		public long get_modification_date ();
		public uint get_n_attachments ();
		public int get_n_pages ();
		public Poppler.Page get_page (int index);
		public Poppler.Page get_page_by_label (string label);
		public Poppler.PageLayout get_page_layout ();
		public Poppler.PageMode get_page_mode ();
		public void get_pdf_version (out uint major_version, out uint minor_version);
		public string get_pdf_version_string ();
		public Poppler.Permissions get_permissions ();
		public string get_producer ();
		public string get_subject ();
		public string get_title ();
		public bool has_attachments ();
		public bool is_linearized ();
		public bool save (string uri) throws GLib.Error;
		public bool save_a_copy (string uri) throws GLib.Error;
		public string author { owned get; }
		public int creation_date { get; }
		public string creator { owned get; }
		[NoAccessorMethod]
		public string format { owned get; }
		[NoAccessorMethod]
		public uint format_major { get; }
		[NoAccessorMethod]
		public uint format_minor { get; }
		public string keywords { owned get; }
		[NoAccessorMethod]
		public bool linearized { get; }
		public string metadata { owned get; }
		[NoAccessorMethod]
		public int mod_date { get; }
		public Poppler.PageLayout page_layout { get; }
		public Poppler.PageMode page_mode { get; }
		public Poppler.Permissions permissions { get; }
		public string producer { owned get; }
		public string subject { owned get; }
		public string title { owned get; }
		[NoAccessorMethod]
		public Poppler.ViewerPreferences viewer_preferences { get; }
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_font_info_get_type ()")]
	public class FontInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public FontInfo (Poppler.Document document);
		public void free ();
		public bool scan (int n_pages, out Poppler.FontsIter iter);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_fonts_iter_get_type ()")]
	[Compact]
	public class FontsIter {
		public Poppler.FontsIter copy ();
		public void free ();
		public unowned string get_encoding ();
		public unowned string get_file_name ();
		public Poppler.FontType get_font_type ();
		public unowned string get_full_name ();
		public unowned string get_name ();
		public unowned string get_substitute_name ();
		public bool is_embedded ();
		public bool is_subset ();
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_form_field_get_type ()")]
	public class FormField : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FormField ();
		public Poppler.FormButtonType button_get_button_type ();
		public bool button_get_state ();
		public void button_set_state (bool state);
		public bool choice_can_select_multiple ();
		public bool choice_commit_on_change ();
		public bool choice_do_spell_check ();
		public Poppler.FormChoiceType choice_get_choice_type ();
		public string choice_get_item (int index);
		public int choice_get_n_items ();
		public string choice_get_text ();
		public bool choice_is_editable ();
		public bool choice_is_item_selected (int index);
		public void choice_select_item (int index);
		public void choice_set_text (string text);
		public void choice_toggle_item (int index);
		public void choice_unselect_all ();
		public unowned Poppler.Action get_action ();
		public Poppler.FormFieldType get_field_type ();
		public double get_font_size ();
		public int get_id ();
		public string get_mapping_name ();
		public string get_name ();
		public string get_partial_name ();
		public bool is_read_only ();
		public bool text_do_scroll ();
		public bool text_do_spell_check ();
		public int text_get_max_len ();
		public string text_get_text ();
		public Poppler.FormTextType text_get_text_type ();
		public bool text_is_password ();
		public bool text_is_rich_text ();
		public void text_set_text (string text);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_form_field_mapping_get_type ()")]
	[Compact]
	public class FormFieldMapping {
		public Poppler.Rectangle area;
		public Poppler.FormField field;
		[CCode (has_construct_function = false)]
		public FormFieldMapping ();
		public Poppler.FormFieldMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_image_mapping_get_type ()")]
	[Compact]
	public class ImageMapping {
		public Poppler.Rectangle area;
		public int image_id;
		[CCode (has_construct_function = false)]
		public ImageMapping ();
		public Poppler.ImageMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_index_iter_get_type ()")]
	[Compact]
	public class IndexIter {
		[CCode (has_construct_function = false)]
		public IndexIter (Poppler.Document document);
		public Poppler.IndexIter copy ();
		public void free ();
		public Poppler.Action get_action ();
		public Poppler.IndexIter get_child ();
		public bool is_open ();
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_layer_get_type ()")]
	public class Layer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Layer ();
		public int get_radio_button_group_id ();
		public unowned string get_title ();
		public void hide ();
		public bool is_parent ();
		public bool is_visible ();
		public void show ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_layers_iter_get_type ()")]
	[Compact]
	public class LayersIter {
		[CCode (has_construct_function = false)]
		public LayersIter (Poppler.Document document);
		public Poppler.LayersIter copy ();
		public void free ();
		public Poppler.LayersIter get_child ();
		public Poppler.Layer get_layer ();
		public string get_title ();
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_link_mapping_get_type ()")]
	[Compact]
	public class LinkMapping {
		public Poppler.Action action;
		public Poppler.Rectangle area;
		[CCode (has_construct_function = false)]
		public LinkMapping ();
		public Poppler.LinkMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_media_get_type ()")]
	public class Media : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Media ();
		public unowned string get_filename ();
		public unowned string get_mime_type ();
		public bool is_embedded ();
		public bool save (string filename) throws GLib.Error;
		public bool save_to_callback (Poppler.MediaSaveFunc save_func) throws GLib.Error;
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_movie_get_type ()")]
	public class Movie : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Movie ();
		public unowned string get_filename ();
		public bool need_poster ();
		public bool show_controls ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_ps_file_get_type ()")]
	public class PSFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public PSFile (Poppler.Document document, string filename, int first_page, int n_pages);
		public void free ();
		public void set_duplex (bool duplex);
		public void set_paper_size (double width, double height);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_page_get_type ()")]
	public class Page : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Page ();
		public void add_annot (Poppler.Annot annot);
		public GLib.List<Poppler.Rectangle> find_text (string text);
		public static void free_annot_mapping (GLib.List<Poppler.AnnotMapping> list);
		public static void free_form_field_mapping (GLib.List<Poppler.FormFieldMapping> list);
		public static void free_image_mapping (GLib.List<Poppler.ImageMapping> list);
		public static void free_link_mapping (GLib.List<Poppler.LinkMapping> list);
		public static void free_text_attributes (GLib.List<Poppler.TextAttributes> list);
		public GLib.List<Poppler.AnnotMapping> get_annot_mapping ();
		public Poppler.Rectangle get_crop_box ();
		public double get_duration ();
		public GLib.List<Poppler.FormFieldMapping> get_form_field_mapping ();
		public Cairo.Surface get_image (int image_id);
		public GLib.List<Poppler.ImageMapping> get_image_mapping ();
		public int get_index ();
		public string get_label ();
		public GLib.List<Poppler.LinkMapping> get_link_mapping ();
		public Cairo.Region get_selected_region (double scale, Poppler.SelectionStyle style, Poppler.Rectangle selection);
		public string get_selected_text (Poppler.SelectionStyle style, Poppler.Rectangle selection);
		[Deprecated (since = "0.16")]
		public GLib.List<Poppler.Rectangle> get_selection_region (double scale, Poppler.SelectionStyle style, Poppler.Rectangle selection);
		public void get_size (out double width, out double height);
		public string get_text ();
		public GLib.List<Poppler.TextAttributes> get_text_attributes ();
		public bool get_text_layout ([CCode (array_length_cname = "n_rectangles", array_length_pos = 1.1, array_length_type = "guint")] out Poppler.Rectangle[] rectangles);
		public Cairo.Surface get_thumbnail ();
		public bool get_thumbnail_size (out int width, out int height);
		public Poppler.PageTransition get_transition ();
		public void render ([CCode (type = "cairo_t*")] Cairo.Context cairo);
		public void render_for_printing ([CCode (type = "cairo_t*")] Cairo.Context cairo);
		public void render_for_printing_with_options ([CCode (type = "cairo_t*")] Cairo.Context cairo, Poppler.PrintFlags options);
		public void render_selection ([CCode (type = "cairo_t*")] Cairo.Context cairo, Poppler.Rectangle selection, Poppler.Rectangle old_selection, Poppler.SelectionStyle style, Poppler.Color glyph_color, Poppler.Color background_color);
		public void render_to_ps (Poppler.PSFile ps_file);
		public static void selection_region_free (GLib.List<Poppler.Rectangle> region);
		public string label { owned get; }
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_page_transition_get_type ()")]
	[Compact]
	public class PageTransition {
		public Poppler.PageTransitionAlignment alignment;
		public int angle;
		public Poppler.PageTransitionDirection direction;
		public int duration;
		public bool rectangular;
		public double scale;
		public Poppler.PageTransitionType type;
		[CCode (has_construct_function = false)]
		public PageTransition ();
		public Poppler.PageTransition copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_text_attributes_get_type ()")]
	[Compact]
	public class TextAttributes {
		public Poppler.Color color;
		public int end_index;
		public string font_name;
		public double font_size;
		public bool is_underlined;
		public int start_index;
		[CCode (has_construct_function = false)]
		public TextAttributes ();
		public Poppler.TextAttributes copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionAny {
		public Poppler.ActionType type;
		public string title;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionGotoDest {
		public Poppler.ActionType type;
		public string title;
		public Poppler.Dest dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionGotoRemote {
		public Poppler.ActionType type;
		public string title;
		public string file_name;
		public Poppler.Dest dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionJavascript {
		public Poppler.ActionType type;
		public string title;
		public string script;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionLaunch {
		public Poppler.ActionType type;
		public string title;
		public string file_name;
		public string @params;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionLayer {
		public Poppler.ActionLayerAction action;
		public weak GLib.List<Poppler.ActionLayer> layers;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionMovie {
		public Poppler.ActionType type;
		public string title;
		public Poppler.ActionMovieOperation operation;
		public Poppler.Movie movie;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionNamed {
		public Poppler.ActionType type;
		public string title;
		public string named_dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionOCGState {
		public Poppler.ActionType type;
		public string title;
		public GLib.List<Poppler.ActionLayer> state_list;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionRendition {
		public Poppler.ActionType type;
		public string title;
		public int op;
		public Poppler.Media media;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionUri {
		public Poppler.ActionType type;
		public string title;
		public string uri;
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_rectangle_get_type ()")]
	public struct Rectangle {
		public double x1;
		public double y1;
		public double x2;
		public double y2;
		[CCode (has_construct_function = false, type = "PopplerRectangle*")]
		public Rectangle ();
		public Poppler.Rectangle copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_LAYER_")]
	public enum ActionLayerAction {
		ON,
		OFF,
		TOGGLE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_MOVIE_")]
	public enum ActionMovieOperation {
		PLAY,
		PAUSE,
		RESUME,
		STOP
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_")]
	public enum ActionType {
		UNKNOWN,
		NONE,
		GOTO_DEST,
		GOTO_REMOTE,
		LAUNCH,
		URI,
		NAMED,
		MOVIE,
		RENDITION,
		OCG_STATE,
		JAVASCRIPT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_")]
	public enum AnnotExternalDataType {
		@3D,
		UNKNOWN
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_FLAG_")]
	[Flags]
	public enum AnnotFlag {
		UNKNOWN,
		INVISIBLE,
		HIDDEN,
		PRINT,
		NO_ZOOM,
		NO_ROTATE,
		NO_VIEW,
		READ_ONLY,
		LOCKED,
		TOGGLE_NO_VIEW,
		LOCKED_CONTENTS
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_FREE_TEXT_QUADDING_")]
	public enum AnnotFreeTextQuadding {
		LEFT_JUSTIFIED,
		CENTERED,
		RIGHT_JUSTIFIED
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_MARKUP_REPLY_TYPE_")]
	public enum AnnotMarkupReplyType {
		R,
		GROUP
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_TEXT_STATE_")]
	public enum AnnotTextState {
		MARKED,
		UNMARKED,
		ACCEPTED,
		REJECTED,
		CANCELLED,
		COMPLETED,
		NONE,
		UNKNOWN
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_")]
	public enum AnnotType {
		UNKNOWN,
		TEXT,
		LINK,
		FREE_TEXT,
		LINE,
		SQUARE,
		CIRCLE,
		POLYGON,
		POLY_LINE,
		HIGHLIGHT,
		UNDERLINE,
		SQUIGGLY,
		STRIKE_OUT,
		STAMP,
		CARET,
		INK,
		POPUP,
		FILE_ATTACHMENT,
		SOUND,
		MOVIE,
		WIDGET,
		SCREEN,
		PRINTER_MARK,
		TRAP_NET,
		WATERMARK,
		@3D
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_BACKEND_")]
	public enum Backend {
		UNKNOWN,
		SPLASH,
		CAIRO
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_DEST_")]
	public enum DestType {
		UNKNOWN,
		XYZ,
		FIT,
		FITH,
		FITV,
		FITR,
		FITB,
		FITBH,
		FITBV,
		NAMED
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FONT_TYPE_")]
	public enum FontType {
		UNKNOWN,
		TYPE1,
		TYPE1C,
		TYPE1COT,
		TYPE3,
		TRUETYPE,
		TRUETYPEOT,
		CID_TYPE0,
		CID_TYPE0C,
		CID_TYPE0COT,
		CID_TYPE2,
		CID_TYPE2OT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_BUTTON_")]
	public enum FormButtonType {
		PUSH,
		CHECK,
		RADIO
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_CHOICE_")]
	public enum FormChoiceType {
		COMBO,
		LIST
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_FIELD_")]
	public enum FormFieldType {
		UNKNOWN,
		BUTTON,
		TEXT,
		CHOICE,
		SIGNATURE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_TEXT_")]
	public enum FormTextType {
		NORMAL,
		MULTILINE,
		FILE_SELECT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ORIENTATION_")]
	public enum Orientation {
		PORTRAIT,
		LANDSCAPE,
		UPSIDEDOWN,
		SEASCAPE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_LAYOUT_")]
	public enum PageLayout {
		UNSET,
		SINGLE_PAGE,
		ONE_COLUMN,
		TWO_COLUMN_LEFT,
		TWO_COLUMN_RIGHT,
		TWO_PAGE_LEFT,
		TWO_PAGE_RIGHT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_MODE_")]
	public enum PageMode {
		UNSET,
		NONE,
		USE_OUTLINES,
		USE_THUMBS,
		FULL_SCREEN,
		USE_OC,
		USE_ATTACHMENTS
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_")]
	public enum PageTransitionAlignment {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_")]
	public enum PageTransitionDirection {
		INWARD,
		OUTWARD
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_")]
	public enum PageTransitionType {
		REPLACE,
		SPLIT,
		BLINDS,
		BOX,
		WIPE,
		DISSOLVE,
		GLITTER,
		FLY,
		PUSH,
		COVER,
		UNCOVER,
		FADE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PERMISSIONS_")]
	[Flags]
	public enum Permissions {
		OK_TO_PRINT,
		OK_TO_MODIFY,
		OK_TO_COPY,
		OK_TO_ADD_NOTES,
		OK_TO_FILL_FORM,
		OK_TO_EXTRACT_CONTENTS,
		OK_TO_ASSEMBLE,
		OK_TO_PRINT_HIGH_RESOLUTION,
		FULL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PRINT_")]
	[Flags]
	public enum PrintFlags {
		DOCUMENT,
		MARKUP_ANNOTS,
		STAMP_ANNOTS_ONLY,
		ALL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_SELECTION_")]
	public enum SelectionStyle {
		GLYPH,
		WORD,
		LINE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_VIEWER_PREFERENCES_")]
	[Flags]
	public enum ViewerPreferences {
		UNSET,
		HIDE_TOOLBAR,
		HIDE_MENUBAR,
		HIDE_WINDOWUI,
		FIT_WINDOW,
		CENTER_WINDOW,
		DISPLAY_DOC_TITLE,
		DIRECTION_RTL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ERROR_")]
	public errordomain Error {
		INVALID,
		ENCRYPTED,
		OPEN_FILE,
		BAD_CATALOG,
		DAMAGED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "poppler.h", instance_pos = 1.9)]
	public delegate bool AttachmentSaveFunc ([CCode (array_length_cname = "count", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buf) throws GLib.Error;
	[CCode (cheader_filename = "poppler.h", instance_pos = 1.9)]
	public delegate bool MediaSaveFunc ([CCode (array_length_cname = "count", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buf) throws GLib.Error;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_HAS_CAIRO")]
	public const int HAS_CAIRO;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "poppler.h")]
	public static bool date_parse (string date, long timet);
	[CCode (cheader_filename = "poppler.h")]
	public static Poppler.Backend get_backend ();
	[CCode (cheader_filename = "poppler.h")]
	public static unowned string get_version ();
}
