/* initializerbuilder.c generated by valac, the Vala compiler
 * generated from initializerbuilder.vala, do not modify */

/* initializerbuilder.vala
 *
 * Copyright (C) 2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <valadoc.h>


#define VALADOC_API_TYPE_INITIALIZER_BUILDER (valadoc_api_initializer_builder_get_type ())
#define VALADOC_API_INITIALIZER_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_API_TYPE_INITIALIZER_BUILDER, ValadocApiInitializerBuilder))
#define VALADOC_API_INITIALIZER_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_API_TYPE_INITIALIZER_BUILDER, ValadocApiInitializerBuilderClass))
#define VALADOC_API_IS_INITIALIZER_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_API_TYPE_INITIALIZER_BUILDER))
#define VALADOC_API_IS_INITIALIZER_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_API_TYPE_INITIALIZER_BUILDER))
#define VALADOC_API_INITIALIZER_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_API_TYPE_INITIALIZER_BUILDER, ValadocApiInitializerBuilderClass))

typedef struct _ValadocApiInitializerBuilder ValadocApiInitializerBuilder;
typedef struct _ValadocApiInitializerBuilderClass ValadocApiInitializerBuilderClass;
typedef struct _ValadocApiInitializerBuilderPrivate ValadocApiInitializerBuilderPrivate;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValadocApiInitializerBuilder {
	ValaCodeVisitor parent_instance;
	ValadocApiInitializerBuilderPrivate * priv;
};

struct _ValadocApiInitializerBuilderClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValadocApiInitializerBuilderPrivate {
	ValaHashMap* symbol_map;
	ValadocApiSignatureBuilder* signature;
};


static gpointer valadoc_api_initializer_builder_parent_class = NULL;

G_GNUC_INTERNAL GType valadoc_api_initializer_builder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALADOC_API_INITIALIZER_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_API_TYPE_INITIALIZER_BUILDER, ValadocApiInitializerBuilderPrivate))
static ValadocApiSymbol* valadoc_api_initializer_builder_resolve (ValadocApiInitializerBuilder* self,
                                                           ValaSymbol* symbol);
static void valadoc_api_initializer_builder_write_node (ValadocApiInitializerBuilder* self,
                                                 ValaSymbol* vsymbol);
static void valadoc_api_initializer_builder_write_type (ValadocApiInitializerBuilder* self,
                                                 ValaDataType* vsymbol);
static void valadoc_api_initializer_builder_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                                           ValaArrayCreationExpression* expr);
G_GNUC_INTERNAL ValadocApiInitializerBuilder* valadoc_api_initializer_builder_new (ValadocApiSignatureBuilder* signature,
                                                                   ValaHashMap* symbol_map);
G_GNUC_INTERNAL ValadocApiInitializerBuilder* valadoc_api_initializer_builder_construct (GType object_type,
                                                                         ValadocApiSignatureBuilder* signature,
                                                                         ValaHashMap* symbol_map);
static void valadoc_api_initializer_builder_real_visit_binary_expression (ValaCodeVisitor* base,
                                                                   ValaBinaryExpression* expr);
static void valadoc_api_initializer_builder_real_visit_unary_expression (ValaCodeVisitor* base,
                                                                  ValaUnaryExpression* expr);
static void valadoc_api_initializer_builder_real_visit_assignment (ValaCodeVisitor* base,
                                                            ValaAssignment* a);
static void valadoc_api_initializer_builder_real_visit_cast_expression (ValaCodeVisitor* base,
                                                                 ValaCastExpression* expr);
static void valadoc_api_initializer_builder_real_visit_initializer_list (ValaCodeVisitor* base,
                                                                  ValaInitializerList* list);
static void valadoc_api_initializer_builder_real_visit_member_access (ValaCodeVisitor* base,
                                                               ValaMemberAccess* expr);
static void valadoc_api_initializer_builder_real_visit_element_access (ValaCodeVisitor* base,
                                                                ValaElementAccess* expr);
static void valadoc_api_initializer_builder_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                                     ValaPointerIndirection* expr);
static void valadoc_api_initializer_builder_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                                      ValaAddressofExpression* expr);
static void valadoc_api_initializer_builder_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                                               ValaReferenceTransferExpression* expr);
static void valadoc_api_initializer_builder_real_visit_type_check (ValaCodeVisitor* base,
                                                            ValaTypeCheck* expr);
static void valadoc_api_initializer_builder_real_visit_method_call (ValaCodeVisitor* base,
                                                             ValaMethodCall* expr);
static void valadoc_api_initializer_builder_real_visit_slice_expression (ValaCodeVisitor* base,
                                                                  ValaSliceExpression* expr);
static void valadoc_api_initializer_builder_real_visit_base_access (ValaCodeVisitor* base,
                                                             ValaBaseAccess* expr);
static void valadoc_api_initializer_builder_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                                    ValaPostfixExpression* expr);
static void valadoc_api_initializer_builder_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                                            ValaObjectCreationExpression* expr);
static void valadoc_api_initializer_builder_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                                                   ValaSizeofExpression* expr);
static void valadoc_api_initializer_builder_real_visit_typeof_expression (ValaCodeVisitor* base,
                                                                   ValaTypeofExpression* expr);
static void valadoc_api_initializer_builder_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                                   ValaLambdaExpression* expr);
static void valadoc_api_initializer_builder_real_visit_boolean_literal (ValaCodeVisitor* base,
                                                                 ValaBooleanLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_character_literal (ValaCodeVisitor* base,
                                                                   ValaCharacterLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_integer_literal (ValaCodeVisitor* base,
                                                                 ValaIntegerLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_real_literal (ValaCodeVisitor* base,
                                                              ValaRealLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_regex_literal (ValaCodeVisitor* base,
                                                               ValaRegexLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_string_literal (ValaCodeVisitor* base,
                                                                ValaStringLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_null_literal (ValaCodeVisitor* base,
                                                              ValaNullLiteral* lit);
static void valadoc_api_initializer_builder_real_visit_field (ValaCodeVisitor* base,
                                                       ValaField* field);
static void valadoc_api_initializer_builder_real_visit_constant (ValaCodeVisitor* base,
                                                          ValaConstant* constant);
static void valadoc_api_initializer_builder_real_visit_enum_value (ValaCodeVisitor* base,
                                                            ValaEnumValue* ev);
static void valadoc_api_initializer_builder_real_visit_error_code (ValaCodeVisitor* base,
                                                            ValaErrorCode* ec);
static void valadoc_api_initializer_builder_real_visit_delegate (ValaCodeVisitor* base,
                                                          ValaDelegate* d);
static void valadoc_api_initializer_builder_real_visit_method (ValaCodeVisitor* base,
                                                        ValaMethod* m);
static void valadoc_api_initializer_builder_real_visit_creation_method (ValaCodeVisitor* base,
                                                                 ValaCreationMethod* m);
static void valadoc_api_initializer_builder_real_visit_signal (ValaCodeVisitor* base,
                                                        ValaSignal* sig);
static void valadoc_api_initializer_builder_real_visit_class (ValaCodeVisitor* base,
                                                       ValaClass* c);
static void valadoc_api_initializer_builder_real_visit_struct (ValaCodeVisitor* base,
                                                        ValaStruct* s);
static void valadoc_api_initializer_builder_real_visit_interface (ValaCodeVisitor* base,
                                                           ValaInterface* i);
static void valadoc_api_initializer_builder_real_visit_enum (ValaCodeVisitor* base,
                                                      ValaEnum* en);
static void valadoc_api_initializer_builder_real_visit_error_domain (ValaCodeVisitor* base,
                                                              ValaErrorDomain* ed);
static void valadoc_api_initializer_builder_real_visit_property (ValaCodeVisitor* base,
                                                          ValaProperty* prop);
static void valadoc_api_initializer_builder_finalize (ValaCodeVisitor * obj);


static ValadocApiSymbol*
valadoc_api_initializer_builder_resolve (ValadocApiInitializerBuilder* self,
                                         ValaSymbol* symbol)
{
	ValadocApiSymbol* result = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->symbol_map;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, symbol);
	result = (ValadocApiSymbol*) _tmp1_;
	return result;
}


static void
valadoc_api_initializer_builder_write_node (ValadocApiInitializerBuilder* self,
                                            ValaSymbol* vsymbol)
{
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSymbol* _tmp1_;
	ValadocApiSymbol* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vsymbol != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_initializer_builder_resolve (self, vsymbol);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_symbol (_tmp0_, (ValadocApiNode*) _tmp2_, TRUE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static void
valadoc_api_initializer_builder_write_type (ValadocApiInitializerBuilder* self,
                                            ValaDataType* vsymbol)
{
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaList* type_args = NULL;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vsymbol != NULL);
	_tmp0_ = vala_data_type_get_data_type (vsymbol);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp2_ = vala_data_type_get_data_type (vsymbol);
		_tmp3_ = _tmp2_;
		valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) _tmp3_);
	} else {
		ValadocApiSignatureBuilder* _tmp4_;
		ValadocApiSignatureBuilder* _tmp5_;
		ValadocApiSignatureBuilder* _tmp6_;
		_tmp4_ = self->priv->signature;
		_tmp5_ = valadoc_api_signature_builder_append_literal (_tmp4_, "null", TRUE);
		_tmp6_ = _tmp5_;
		_valadoc_api_signature_builder_unref0 (_tmp6_);
	}
	_tmp7_ = vala_data_type_get_type_arguments (vsymbol);
	type_args = _tmp7_;
	_tmp8_ = type_args;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		ValadocApiSignatureBuilder* _tmp11_;
		ValadocApiSignatureBuilder* _tmp12_;
		ValadocApiSignatureBuilder* _tmp13_;
		gboolean first = FALSE;
		ValadocApiSignatureBuilder* _tmp41_;
		ValadocApiSignatureBuilder* _tmp42_;
		ValadocApiSignatureBuilder* _tmp43_;
		_tmp11_ = self->priv->signature;
		_tmp12_ = valadoc_api_signature_builder_append (_tmp11_, "<", TRUE);
		_tmp13_ = _tmp12_;
		_valadoc_api_signature_builder_unref0 (_tmp13_);
		first = TRUE;
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _type_arg_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _type_arg_index = 0;
			_tmp14_ = type_args;
			_tmp15_ = _vala_iterable_ref0 (_tmp14_);
			_type_arg_list = _tmp15_;
			_tmp16_ = _type_arg_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_type_arg_size = _tmp18_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp22_;
				gint _tmp23_;
				gpointer _tmp24_;
				gboolean _tmp25_;
				ValaDataType* _tmp29_;
				gboolean _tmp30_;
				gboolean _tmp31_;
				ValadocApiSignatureBuilder* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				ValadocApiSignatureBuilder* _tmp39_;
				ValadocApiSignatureBuilder* _tmp40_;
				_tmp19_ = _type_arg_index;
				_type_arg_index = _tmp19_ + 1;
				_tmp20_ = _type_arg_index;
				_tmp21_ = _type_arg_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _type_arg_list;
				_tmp23_ = _type_arg_index;
				_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
				type_arg = (ValaDataType*) _tmp24_;
				_tmp25_ = first;
				if (!_tmp25_) {
					ValadocApiSignatureBuilder* _tmp26_;
					ValadocApiSignatureBuilder* _tmp27_;
					ValadocApiSignatureBuilder* _tmp28_;
					_tmp26_ = self->priv->signature;
					_tmp27_ = valadoc_api_signature_builder_append (_tmp26_, ",", TRUE);
					_tmp28_ = _tmp27_;
					_valadoc_api_signature_builder_unref0 (_tmp28_);
				} else {
					first = FALSE;
				}
				_tmp29_ = type_arg;
				_tmp30_ = vala_data_type_get_value_owned (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					ValadocApiSignatureBuilder* _tmp32_;
					ValadocApiSignatureBuilder* _tmp33_;
					ValadocApiSignatureBuilder* _tmp34_;
					_tmp32_ = self->priv->signature;
					_tmp33_ = valadoc_api_signature_builder_append_keyword (_tmp32_, "weak", TRUE);
					_tmp34_ = _tmp33_;
					_valadoc_api_signature_builder_unref0 (_tmp34_);
				}
				_tmp35_ = self->priv->signature;
				_tmp36_ = type_arg;
				_tmp37_ = vala_data_type_to_qualified_string (_tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = valadoc_api_signature_builder_append (_tmp35_, _tmp38_, TRUE);
				_tmp40_ = _tmp39_;
				_valadoc_api_signature_builder_unref0 (_tmp40_);
				_g_free0 (_tmp38_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_tmp41_ = self->priv->signature;
		_tmp42_ = valadoc_api_signature_builder_append (_tmp41_, ">", TRUE);
		_tmp43_ = _tmp42_;
		_valadoc_api_signature_builder_unref0 (_tmp43_);
	}
	_tmp44_ = vala_data_type_get_nullable (vsymbol);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		ValadocApiSignatureBuilder* _tmp46_;
		ValadocApiSignatureBuilder* _tmp47_;
		ValadocApiSignatureBuilder* _tmp48_;
		_tmp46_ = self->priv->signature;
		_tmp47_ = valadoc_api_signature_builder_append (_tmp46_, "?", TRUE);
		_tmp48_ = _tmp47_;
		_valadoc_api_signature_builder_unref0 (_tmp48_);
	}
	_vala_iterable_unref0 (type_args);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                                      ValaArrayCreationExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValadocApiSignatureBuilder* _tmp5_;
	ValadocApiSignatureBuilder* _tmp6_;
	ValadocApiSignatureBuilder* _tmp7_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp23_;
	ValadocApiSignatureBuilder* _tmp24_;
	ValadocApiSignatureBuilder* _tmp25_;
	ValaInitializerList* _tmp26_;
	ValaInitializerList* _tmp27_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append_keyword (_tmp0_, "new", TRUE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp3_ = vala_array_creation_expression_get_element_type (expr);
	_tmp4_ = _tmp3_;
	valadoc_api_initializer_builder_write_type (self, _tmp4_);
	_tmp5_ = self->priv->signature;
	_tmp6_ = valadoc_api_signature_builder_append (_tmp5_, "[", FALSE);
	_tmp7_ = _tmp6_;
	_valadoc_api_signature_builder_unref0 (_tmp7_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp8_;
		gint _size_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _size_index = 0;
		_tmp8_ = vala_array_creation_expression_get_sizes (expr);
		_size_list = _tmp8_;
		_tmp9_ = _size_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_size_size = _tmp11_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* size = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_;
			ValaExpression* _tmp22_;
			_tmp12_ = _size_index;
			_size_index = _tmp12_ + 1;
			_tmp13_ = _size_index;
			_tmp14_ = _size_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _size_list;
			_tmp16_ = _size_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			size = (ValaExpression*) _tmp17_;
			_tmp18_ = first;
			if (!_tmp18_) {
				ValadocApiSignatureBuilder* _tmp19_;
				ValadocApiSignatureBuilder* _tmp20_;
				ValadocApiSignatureBuilder* _tmp21_;
				_tmp19_ = self->priv->signature;
				_tmp20_ = valadoc_api_signature_builder_append (_tmp19_, ", ", FALSE);
				_tmp21_ = _tmp20_;
				_valadoc_api_signature_builder_unref0 (_tmp21_);
			}
			_tmp22_ = size;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, (ValaCodeVisitor*) self);
			first = FALSE;
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp23_ = self->priv->signature;
	_tmp24_ = valadoc_api_signature_builder_append (_tmp23_, "]", FALSE);
	_tmp25_ = _tmp24_;
	_valadoc_api_signature_builder_unref0 (_tmp25_);
	_tmp26_ = vala_array_creation_expression_get_initializer_list (expr);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValadocApiSignatureBuilder* _tmp28_;
		ValadocApiSignatureBuilder* _tmp29_;
		ValadocApiSignatureBuilder* _tmp30_;
		ValaInitializerList* _tmp31_;
		ValaInitializerList* _tmp32_;
		_tmp28_ = self->priv->signature;
		_tmp29_ = valadoc_api_signature_builder_append (_tmp28_, " ", FALSE);
		_tmp30_ = _tmp29_;
		_valadoc_api_signature_builder_unref0 (_tmp30_);
		_tmp31_ = vala_array_creation_expression_get_initializer_list (expr);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, (ValaCodeVisitor*) self);
	}
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_valadoc_api_signature_builder_ref0 (gpointer self)
{
	return self ? valadoc_api_signature_builder_ref (self) : NULL;
}


G_GNUC_INTERNAL ValadocApiInitializerBuilder*
valadoc_api_initializer_builder_construct (GType object_type,
                                           ValadocApiSignatureBuilder* signature,
                                           ValaHashMap* symbol_map)
{
	ValadocApiInitializerBuilder* self = NULL;
	ValaHashMap* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	g_return_val_if_fail (signature != NULL, NULL);
	g_return_val_if_fail (symbol_map != NULL, NULL);
	self = (ValadocApiInitializerBuilder*) vala_code_visitor_construct (object_type);
	_tmp0_ = _vala_map_ref0 (symbol_map);
	_vala_map_unref0 (self->priv->symbol_map);
	self->priv->symbol_map = _tmp0_;
	_tmp1_ = _valadoc_api_signature_builder_ref0 (signature);
	_valadoc_api_signature_builder_unref0 (self->priv->signature);
	self->priv->signature = _tmp1_;
	return self;
}


G_GNUC_INTERNAL ValadocApiInitializerBuilder*
valadoc_api_initializer_builder_new (ValadocApiSignatureBuilder* signature,
                                     ValaHashMap* symbol_map)
{
	return valadoc_api_initializer_builder_construct (VALADOC_API_TYPE_INITIALIZER_BUILDER, signature, symbol_map);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_binary_expression (ValaCodeVisitor* base,
                                                              ValaBinaryExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryOperator _tmp2_;
	ValaBinaryOperator _tmp3_;
	ValaExpression* _tmp67_;
	ValaExpression* _tmp68_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_binary_expression_get_left (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = vala_binary_expression_get_operator (expr);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			ValadocApiSignatureBuilder* _tmp4_;
			ValadocApiSignatureBuilder* _tmp5_;
			ValadocApiSignatureBuilder* _tmp6_;
			_tmp4_ = self->priv->signature;
			_tmp5_ = valadoc_api_signature_builder_append (_tmp4_, "+ ", TRUE);
			_tmp6_ = _tmp5_;
			_valadoc_api_signature_builder_unref0 (_tmp6_);
			break;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			ValadocApiSignatureBuilder* _tmp7_;
			ValadocApiSignatureBuilder* _tmp8_;
			ValadocApiSignatureBuilder* _tmp9_;
			_tmp7_ = self->priv->signature;
			_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, "- ", TRUE);
			_tmp9_ = _tmp8_;
			_valadoc_api_signature_builder_unref0 (_tmp9_);
			break;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			ValadocApiSignatureBuilder* _tmp10_;
			ValadocApiSignatureBuilder* _tmp11_;
			ValadocApiSignatureBuilder* _tmp12_;
			_tmp10_ = self->priv->signature;
			_tmp11_ = valadoc_api_signature_builder_append (_tmp10_, "* ", TRUE);
			_tmp12_ = _tmp11_;
			_valadoc_api_signature_builder_unref0 (_tmp12_);
			break;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			ValadocApiSignatureBuilder* _tmp13_;
			ValadocApiSignatureBuilder* _tmp14_;
			ValadocApiSignatureBuilder* _tmp15_;
			_tmp13_ = self->priv->signature;
			_tmp14_ = valadoc_api_signature_builder_append (_tmp13_, "/ ", TRUE);
			_tmp15_ = _tmp14_;
			_valadoc_api_signature_builder_unref0 (_tmp15_);
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			ValadocApiSignatureBuilder* _tmp16_;
			ValadocApiSignatureBuilder* _tmp17_;
			ValadocApiSignatureBuilder* _tmp18_;
			_tmp16_ = self->priv->signature;
			_tmp17_ = valadoc_api_signature_builder_append (_tmp16_, "% ", TRUE);
			_tmp18_ = _tmp17_;
			_valadoc_api_signature_builder_unref0 (_tmp18_);
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			ValadocApiSignatureBuilder* _tmp19_;
			ValadocApiSignatureBuilder* _tmp20_;
			ValadocApiSignatureBuilder* _tmp21_;
			_tmp19_ = self->priv->signature;
			_tmp20_ = valadoc_api_signature_builder_append (_tmp19_, "<< ", TRUE);
			_tmp21_ = _tmp20_;
			_valadoc_api_signature_builder_unref0 (_tmp21_);
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			ValadocApiSignatureBuilder* _tmp22_;
			ValadocApiSignatureBuilder* _tmp23_;
			ValadocApiSignatureBuilder* _tmp24_;
			_tmp22_ = self->priv->signature;
			_tmp23_ = valadoc_api_signature_builder_append (_tmp22_, ">> ", TRUE);
			_tmp24_ = _tmp23_;
			_valadoc_api_signature_builder_unref0 (_tmp24_);
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			ValadocApiSignatureBuilder* _tmp25_;
			ValadocApiSignatureBuilder* _tmp26_;
			ValadocApiSignatureBuilder* _tmp27_;
			_tmp25_ = self->priv->signature;
			_tmp26_ = valadoc_api_signature_builder_append (_tmp25_, "< ", TRUE);
			_tmp27_ = _tmp26_;
			_valadoc_api_signature_builder_unref0 (_tmp27_);
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			ValadocApiSignatureBuilder* _tmp28_;
			ValadocApiSignatureBuilder* _tmp29_;
			ValadocApiSignatureBuilder* _tmp30_;
			_tmp28_ = self->priv->signature;
			_tmp29_ = valadoc_api_signature_builder_append (_tmp28_, "> ", TRUE);
			_tmp30_ = _tmp29_;
			_valadoc_api_signature_builder_unref0 (_tmp30_);
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			ValadocApiSignatureBuilder* _tmp31_;
			ValadocApiSignatureBuilder* _tmp32_;
			ValadocApiSignatureBuilder* _tmp33_;
			_tmp31_ = self->priv->signature;
			_tmp32_ = valadoc_api_signature_builder_append (_tmp31_, "<= ", TRUE);
			_tmp33_ = _tmp32_;
			_valadoc_api_signature_builder_unref0 (_tmp33_);
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			ValadocApiSignatureBuilder* _tmp34_;
			ValadocApiSignatureBuilder* _tmp35_;
			ValadocApiSignatureBuilder* _tmp36_;
			_tmp34_ = self->priv->signature;
			_tmp35_ = valadoc_api_signature_builder_append (_tmp34_, ">= ", TRUE);
			_tmp36_ = _tmp35_;
			_valadoc_api_signature_builder_unref0 (_tmp36_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			ValadocApiSignatureBuilder* _tmp37_;
			ValadocApiSignatureBuilder* _tmp38_;
			ValadocApiSignatureBuilder* _tmp39_;
			_tmp37_ = self->priv->signature;
			_tmp38_ = valadoc_api_signature_builder_append (_tmp37_, "== ", TRUE);
			_tmp39_ = _tmp38_;
			_valadoc_api_signature_builder_unref0 (_tmp39_);
			break;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			ValadocApiSignatureBuilder* _tmp40_;
			ValadocApiSignatureBuilder* _tmp41_;
			ValadocApiSignatureBuilder* _tmp42_;
			_tmp40_ = self->priv->signature;
			_tmp41_ = valadoc_api_signature_builder_append (_tmp40_, "!= ", TRUE);
			_tmp42_ = _tmp41_;
			_valadoc_api_signature_builder_unref0 (_tmp42_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			ValadocApiSignatureBuilder* _tmp43_;
			ValadocApiSignatureBuilder* _tmp44_;
			ValadocApiSignatureBuilder* _tmp45_;
			_tmp43_ = self->priv->signature;
			_tmp44_ = valadoc_api_signature_builder_append (_tmp43_, "& ", TRUE);
			_tmp45_ = _tmp44_;
			_valadoc_api_signature_builder_unref0 (_tmp45_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			ValadocApiSignatureBuilder* _tmp46_;
			ValadocApiSignatureBuilder* _tmp47_;
			ValadocApiSignatureBuilder* _tmp48_;
			_tmp46_ = self->priv->signature;
			_tmp47_ = valadoc_api_signature_builder_append (_tmp46_, "| ", TRUE);
			_tmp48_ = _tmp47_;
			_valadoc_api_signature_builder_unref0 (_tmp48_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			ValadocApiSignatureBuilder* _tmp49_;
			ValadocApiSignatureBuilder* _tmp50_;
			ValadocApiSignatureBuilder* _tmp51_;
			_tmp49_ = self->priv->signature;
			_tmp50_ = valadoc_api_signature_builder_append (_tmp49_, "^ ", TRUE);
			_tmp51_ = _tmp50_;
			_valadoc_api_signature_builder_unref0 (_tmp51_);
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			ValadocApiSignatureBuilder* _tmp52_;
			ValadocApiSignatureBuilder* _tmp53_;
			ValadocApiSignatureBuilder* _tmp54_;
			_tmp52_ = self->priv->signature;
			_tmp53_ = valadoc_api_signature_builder_append (_tmp52_, "&& ", TRUE);
			_tmp54_ = _tmp53_;
			_valadoc_api_signature_builder_unref0 (_tmp54_);
			break;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			ValadocApiSignatureBuilder* _tmp55_;
			ValadocApiSignatureBuilder* _tmp56_;
			ValadocApiSignatureBuilder* _tmp57_;
			_tmp55_ = self->priv->signature;
			_tmp56_ = valadoc_api_signature_builder_append (_tmp55_, "|| ", TRUE);
			_tmp57_ = _tmp56_;
			_valadoc_api_signature_builder_unref0 (_tmp57_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			ValadocApiSignatureBuilder* _tmp58_;
			ValadocApiSignatureBuilder* _tmp59_;
			ValadocApiSignatureBuilder* _tmp60_;
			ValadocApiSignatureBuilder* _tmp61_;
			ValadocApiSignatureBuilder* _tmp62_;
			ValadocApiSignatureBuilder* _tmp63_;
			_tmp58_ = self->priv->signature;
			_tmp59_ = valadoc_api_signature_builder_append_keyword (_tmp58_, "in", TRUE);
			_tmp60_ = _tmp59_;
			_valadoc_api_signature_builder_unref0 (_tmp60_);
			_tmp61_ = self->priv->signature;
			_tmp62_ = valadoc_api_signature_builder_append (_tmp61_, " ", TRUE);
			_tmp63_ = _tmp62_;
			_valadoc_api_signature_builder_unref0 (_tmp63_);
			break;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			ValadocApiSignatureBuilder* _tmp64_;
			ValadocApiSignatureBuilder* _tmp65_;
			ValadocApiSignatureBuilder* _tmp66_;
			_tmp64_ = self->priv->signature;
			_tmp65_ = valadoc_api_signature_builder_append (_tmp64_, "?? ", TRUE);
			_tmp66_ = _tmp65_;
			_valadoc_api_signature_builder_unref0 (_tmp66_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp67_ = vala_binary_expression_get_right (expr);
	_tmp68_ = _tmp67_;
	vala_code_node_accept ((ValaCodeNode*) _tmp68_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_unary_expression (ValaCodeVisitor* base,
                                                             ValaUnaryExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaUnaryOperator _tmp0_;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_unary_expression_get_operator (expr);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			ValadocApiSignatureBuilder* _tmp2_;
			ValadocApiSignatureBuilder* _tmp3_;
			ValadocApiSignatureBuilder* _tmp4_;
			_tmp2_ = self->priv->signature;
			_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, "+", TRUE);
			_tmp4_ = _tmp3_;
			_valadoc_api_signature_builder_unref0 (_tmp4_);
			break;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			ValadocApiSignatureBuilder* _tmp5_;
			ValadocApiSignatureBuilder* _tmp6_;
			ValadocApiSignatureBuilder* _tmp7_;
			_tmp5_ = self->priv->signature;
			_tmp6_ = valadoc_api_signature_builder_append (_tmp5_, "-", TRUE);
			_tmp7_ = _tmp6_;
			_valadoc_api_signature_builder_unref0 (_tmp7_);
			break;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			ValadocApiSignatureBuilder* _tmp8_;
			ValadocApiSignatureBuilder* _tmp9_;
			ValadocApiSignatureBuilder* _tmp10_;
			_tmp8_ = self->priv->signature;
			_tmp9_ = valadoc_api_signature_builder_append (_tmp8_, "!", TRUE);
			_tmp10_ = _tmp9_;
			_valadoc_api_signature_builder_unref0 (_tmp10_);
			break;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			ValadocApiSignatureBuilder* _tmp11_;
			ValadocApiSignatureBuilder* _tmp12_;
			ValadocApiSignatureBuilder* _tmp13_;
			_tmp11_ = self->priv->signature;
			_tmp12_ = valadoc_api_signature_builder_append (_tmp11_, "~", TRUE);
			_tmp13_ = _tmp12_;
			_valadoc_api_signature_builder_unref0 (_tmp13_);
			break;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			ValadocApiSignatureBuilder* _tmp14_;
			ValadocApiSignatureBuilder* _tmp15_;
			ValadocApiSignatureBuilder* _tmp16_;
			_tmp14_ = self->priv->signature;
			_tmp15_ = valadoc_api_signature_builder_append (_tmp14_, "++", TRUE);
			_tmp16_ = _tmp15_;
			_valadoc_api_signature_builder_unref0 (_tmp16_);
			break;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			ValadocApiSignatureBuilder* _tmp17_;
			ValadocApiSignatureBuilder* _tmp18_;
			ValadocApiSignatureBuilder* _tmp19_;
			_tmp17_ = self->priv->signature;
			_tmp18_ = valadoc_api_signature_builder_append (_tmp17_, "--", TRUE);
			_tmp19_ = _tmp18_;
			_valadoc_api_signature_builder_unref0 (_tmp19_);
			break;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			ValadocApiSignatureBuilder* _tmp20_;
			ValadocApiSignatureBuilder* _tmp21_;
			ValadocApiSignatureBuilder* _tmp22_;
			_tmp20_ = self->priv->signature;
			_tmp21_ = valadoc_api_signature_builder_append_keyword (_tmp20_, "ref", TRUE);
			_tmp22_ = _tmp21_;
			_valadoc_api_signature_builder_unref0 (_tmp22_);
			break;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			ValadocApiSignatureBuilder* _tmp23_;
			ValadocApiSignatureBuilder* _tmp24_;
			ValadocApiSignatureBuilder* _tmp25_;
			_tmp23_ = self->priv->signature;
			_tmp24_ = valadoc_api_signature_builder_append_keyword (_tmp23_, "out", TRUE);
			_tmp25_ = _tmp24_;
			_valadoc_api_signature_builder_unref0 (_tmp25_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp26_ = vala_unary_expression_get_inner (expr);
	_tmp27_ = _tmp26_;
	vala_code_node_accept ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_assignment (ValaCodeVisitor* base,
                                                       ValaAssignment* a)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaAssignmentOperator _tmp2_;
	ValaAssignmentOperator _tmp3_;
	ValaExpression* _tmp37_;
	ValaExpression* _tmp38_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_assignment_get_left (a);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = vala_assignment_get_operator (a);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			ValadocApiSignatureBuilder* _tmp4_;
			ValadocApiSignatureBuilder* _tmp5_;
			ValadocApiSignatureBuilder* _tmp6_;
			_tmp4_ = self->priv->signature;
			_tmp5_ = valadoc_api_signature_builder_append (_tmp4_, "=", TRUE);
			_tmp6_ = _tmp5_;
			_valadoc_api_signature_builder_unref0 (_tmp6_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			ValadocApiSignatureBuilder* _tmp7_;
			ValadocApiSignatureBuilder* _tmp8_;
			ValadocApiSignatureBuilder* _tmp9_;
			_tmp7_ = self->priv->signature;
			_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, "|", TRUE);
			_tmp9_ = _tmp8_;
			_valadoc_api_signature_builder_unref0 (_tmp9_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			ValadocApiSignatureBuilder* _tmp10_;
			ValadocApiSignatureBuilder* _tmp11_;
			ValadocApiSignatureBuilder* _tmp12_;
			_tmp10_ = self->priv->signature;
			_tmp11_ = valadoc_api_signature_builder_append (_tmp10_, "&", TRUE);
			_tmp12_ = _tmp11_;
			_valadoc_api_signature_builder_unref0 (_tmp12_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			ValadocApiSignatureBuilder* _tmp13_;
			ValadocApiSignatureBuilder* _tmp14_;
			ValadocApiSignatureBuilder* _tmp15_;
			_tmp13_ = self->priv->signature;
			_tmp14_ = valadoc_api_signature_builder_append (_tmp13_, "^", TRUE);
			_tmp15_ = _tmp14_;
			_valadoc_api_signature_builder_unref0 (_tmp15_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			ValadocApiSignatureBuilder* _tmp16_;
			ValadocApiSignatureBuilder* _tmp17_;
			ValadocApiSignatureBuilder* _tmp18_;
			_tmp16_ = self->priv->signature;
			_tmp17_ = valadoc_api_signature_builder_append (_tmp16_, "+", TRUE);
			_tmp18_ = _tmp17_;
			_valadoc_api_signature_builder_unref0 (_tmp18_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			ValadocApiSignatureBuilder* _tmp19_;
			ValadocApiSignatureBuilder* _tmp20_;
			ValadocApiSignatureBuilder* _tmp21_;
			_tmp19_ = self->priv->signature;
			_tmp20_ = valadoc_api_signature_builder_append (_tmp19_, "-", TRUE);
			_tmp21_ = _tmp20_;
			_valadoc_api_signature_builder_unref0 (_tmp21_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			ValadocApiSignatureBuilder* _tmp22_;
			ValadocApiSignatureBuilder* _tmp23_;
			ValadocApiSignatureBuilder* _tmp24_;
			_tmp22_ = self->priv->signature;
			_tmp23_ = valadoc_api_signature_builder_append (_tmp22_, "*", TRUE);
			_tmp24_ = _tmp23_;
			_valadoc_api_signature_builder_unref0 (_tmp24_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			ValadocApiSignatureBuilder* _tmp25_;
			ValadocApiSignatureBuilder* _tmp26_;
			ValadocApiSignatureBuilder* _tmp27_;
			_tmp25_ = self->priv->signature;
			_tmp26_ = valadoc_api_signature_builder_append (_tmp25_, "/", TRUE);
			_tmp27_ = _tmp26_;
			_valadoc_api_signature_builder_unref0 (_tmp27_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			ValadocApiSignatureBuilder* _tmp28_;
			ValadocApiSignatureBuilder* _tmp29_;
			ValadocApiSignatureBuilder* _tmp30_;
			_tmp28_ = self->priv->signature;
			_tmp29_ = valadoc_api_signature_builder_append (_tmp28_, "%", TRUE);
			_tmp30_ = _tmp29_;
			_valadoc_api_signature_builder_unref0 (_tmp30_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			ValadocApiSignatureBuilder* _tmp31_;
			ValadocApiSignatureBuilder* _tmp32_;
			ValadocApiSignatureBuilder* _tmp33_;
			_tmp31_ = self->priv->signature;
			_tmp32_ = valadoc_api_signature_builder_append (_tmp31_, "<<", TRUE);
			_tmp33_ = _tmp32_;
			_valadoc_api_signature_builder_unref0 (_tmp33_);
			break;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			ValadocApiSignatureBuilder* _tmp34_;
			ValadocApiSignatureBuilder* _tmp35_;
			ValadocApiSignatureBuilder* _tmp36_;
			_tmp34_ = self->priv->signature;
			_tmp35_ = valadoc_api_signature_builder_append (_tmp34_, ">>", TRUE);
			_tmp36_ = _tmp35_;
			_valadoc_api_signature_builder_unref0 (_tmp36_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp37_ = vala_assignment_get_right (a);
	_tmp38_ = _tmp37_;
	vala_code_node_accept ((ValaCodeNode*) _tmp38_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_cast_expression (ValaCodeVisitor* base,
                                                            ValaCastExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	ValaExpression* _tmp17_;
	ValaExpression* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_cast_expression_get_is_non_null_cast (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValadocApiSignatureBuilder* _tmp2_;
		ValadocApiSignatureBuilder* _tmp3_;
		ValadocApiSignatureBuilder* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp2_ = self->priv->signature;
		_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, "(!)", TRUE);
		_tmp4_ = _tmp3_;
		_valadoc_api_signature_builder_unref0 (_tmp4_);
		_tmp5_ = vala_cast_expression_get_inner (expr);
		_tmp6_ = _tmp5_;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp7_ = vala_cast_expression_get_is_silent_cast (expr);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		ValadocApiSignatureBuilder* _tmp9_;
		ValadocApiSignatureBuilder* _tmp10_;
		ValadocApiSignatureBuilder* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValadocApiSignatureBuilder* _tmp14_;
		ValadocApiSignatureBuilder* _tmp15_;
		ValadocApiSignatureBuilder* _tmp16_;
		_tmp9_ = self->priv->signature;
		_tmp10_ = valadoc_api_signature_builder_append (_tmp9_, "(", FALSE);
		_tmp11_ = _tmp10_;
		_valadoc_api_signature_builder_unref0 (_tmp11_);
		_tmp12_ = vala_cast_expression_get_type_reference (expr);
		_tmp13_ = _tmp12_;
		valadoc_api_initializer_builder_write_type (self, _tmp13_);
		_tmp14_ = self->priv->signature;
		_tmp15_ = valadoc_api_signature_builder_append (_tmp14_, ")", FALSE);
		_tmp16_ = _tmp15_;
		_valadoc_api_signature_builder_unref0 (_tmp16_);
	}
	_tmp17_ = vala_cast_expression_get_inner (expr);
	_tmp18_ = _tmp17_;
	vala_code_node_accept ((ValaCodeNode*) _tmp18_, (ValaCodeVisitor*) self);
	_tmp19_ = vala_cast_expression_get_is_silent_cast (expr);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		ValadocApiSignatureBuilder* _tmp21_;
		ValadocApiSignatureBuilder* _tmp22_;
		ValadocApiSignatureBuilder* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		_tmp21_ = self->priv->signature;
		_tmp22_ = valadoc_api_signature_builder_append_keyword (_tmp21_, "as", TRUE);
		_tmp23_ = _tmp22_;
		_valadoc_api_signature_builder_unref0 (_tmp23_);
		_tmp24_ = vala_cast_expression_get_type_reference (expr);
		_tmp25_ = _tmp24_;
		valadoc_api_initializer_builder_write_type (self, _tmp25_);
	}
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_initializer_list (ValaCodeVisitor* base,
                                                             ValaInitializerList* list)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp18_;
	ValadocApiSignatureBuilder* _tmp19_;
	ValadocApiSignatureBuilder* _tmp20_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append (_tmp0_, "{", FALSE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp3_;
		gint _initializer_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _initializer_index = 0;
		_tmp3_ = vala_initializer_list_get_initializers (list);
		_initializer_list = _tmp3_;
		_tmp4_ = _initializer_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_initializer_size = _tmp6_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_;
			ValaExpression* _tmp17_;
			_tmp7_ = _initializer_index;
			_initializer_index = _tmp7_ + 1;
			_tmp8_ = _initializer_index;
			_tmp9_ = _initializer_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _initializer_list;
			_tmp11_ = _initializer_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			initializer = (ValaExpression*) _tmp12_;
			_tmp13_ = first;
			if (!_tmp13_) {
				ValadocApiSignatureBuilder* _tmp14_;
				ValadocApiSignatureBuilder* _tmp15_;
				ValadocApiSignatureBuilder* _tmp16_;
				_tmp14_ = self->priv->signature;
				_tmp15_ = valadoc_api_signature_builder_append (_tmp14_, ", ", FALSE);
				_tmp16_ = _tmp15_;
				_valadoc_api_signature_builder_unref0 (_tmp16_);
			}
			first = FALSE;
			_tmp17_ = initializer;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp18_ = self->priv->signature;
	_tmp19_ = valadoc_api_signature_builder_append (_tmp18_, "}", FALSE);
	_tmp20_ = _tmp19_;
	_valadoc_api_signature_builder_unref0 (_tmp20_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_member_access (ValaCodeVisitor* base,
                                                          ValaMemberAccess* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	} else {
		ValadocApiSignatureBuilder* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiSignatureBuilder* _tmp7_;
		ValadocApiSignatureBuilder* _tmp8_;
		_tmp4_ = self->priv->signature;
		_tmp5_ = vala_member_access_get_member_name (expr);
		_tmp6_ = _tmp5_;
		_tmp7_ = valadoc_api_signature_builder_append (_tmp4_, _tmp6_, TRUE);
		_tmp8_ = _tmp7_;
		_valadoc_api_signature_builder_unref0 (_tmp8_);
	}
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_element_access (ValaCodeVisitor* base,
                                                           ValaElementAccess* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp20_;
	ValadocApiSignatureBuilder* _tmp21_;
	ValadocApiSignatureBuilder* _tmp22_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_element_access_get_container (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = self->priv->signature;
	_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, "[", FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp5_;
		gint _index_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _index_index = 0;
		_tmp5_ = vala_element_access_get_indices (expr);
		_index_list = _tmp5_;
		_tmp6_ = _index_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_index_size = _tmp8_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* index = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			gboolean _tmp15_;
			ValaExpression* _tmp19_;
			_tmp9_ = _index_index;
			_index_index = _tmp9_ + 1;
			_tmp10_ = _index_index;
			_tmp11_ = _index_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _index_list;
			_tmp13_ = _index_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			index = (ValaExpression*) _tmp14_;
			_tmp15_ = first;
			if (!_tmp15_) {
				ValadocApiSignatureBuilder* _tmp16_;
				ValadocApiSignatureBuilder* _tmp17_;
				ValadocApiSignatureBuilder* _tmp18_;
				_tmp16_ = self->priv->signature;
				_tmp17_ = valadoc_api_signature_builder_append (_tmp16_, ", ", FALSE);
				_tmp18_ = _tmp17_;
				_valadoc_api_signature_builder_unref0 (_tmp18_);
			}
			first = FALSE;
			_tmp19_ = index;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp20_ = self->priv->signature;
	_tmp21_ = valadoc_api_signature_builder_append (_tmp20_, "]", FALSE);
	_tmp22_ = _tmp21_;
	_valadoc_api_signature_builder_unref0 (_tmp22_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                                ValaPointerIndirection* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append (_tmp0_, "*", FALSE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp3_ = vala_pointer_indirection_get_inner (expr);
	_tmp4_ = _tmp3_;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                                 ValaAddressofExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append (_tmp0_, "&", FALSE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp3_ = vala_addressof_expression_get_inner (expr);
	_tmp4_ = _tmp3_;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                                          ValaReferenceTransferExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValadocApiSignatureBuilder* _tmp5_;
	ValadocApiSignatureBuilder* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append (_tmp0_, "(", FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_keyword (_tmp2_, "owned", FALSE);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_signature_builder_append (_tmp4_, ")", FALSE);
	_tmp6_ = _tmp5_;
	_valadoc_api_signature_builder_unref0 (_tmp6_);
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp7_ = vala_reference_transfer_expression_get_inner (expr);
	_tmp8_ = _tmp7_;
	vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_type_check (ValaCodeVisitor* base,
                                                       ValaTypeCheck* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_typecheck_get_expression (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = self->priv->signature;
	_tmp3_ = valadoc_api_signature_builder_append_keyword (_tmp2_, "is", TRUE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_tmp5_ = vala_typecheck_get_type_reference (expr);
	_tmp6_ = _tmp5_;
	valadoc_api_initializer_builder_write_type (self, _tmp6_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_method_call (ValaCodeVisitor* base,
                                                        ValaMethodCall* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValadocApiSignatureBuilder* _tmp5_;
	ValadocApiSignatureBuilder* _tmp6_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp22_;
	ValadocApiSignatureBuilder* _tmp23_;
	ValadocApiSignatureBuilder* _tmp24_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	_tmp4_ = self->priv->signature;
	_tmp5_ = valadoc_api_signature_builder_append (_tmp4_, " (", FALSE);
	_tmp6_ = _tmp5_;
	_valadoc_api_signature_builder_unref0 (_tmp6_);
	first = TRUE;
	{
		ValaList* _literal_list = NULL;
		ValaList* _tmp7_;
		gint _literal_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _literal_index = 0;
		_tmp7_ = vala_method_call_get_argument_list (expr);
		_literal_list = _tmp7_;
		_tmp8_ = _literal_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_literal_size = _tmp10_;
		_literal_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* literal = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gboolean _tmp17_;
			ValaExpression* _tmp21_;
			_tmp11_ = _literal_index;
			_literal_index = _tmp11_ + 1;
			_tmp12_ = _literal_index;
			_tmp13_ = _literal_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _literal_list;
			_tmp15_ = _literal_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			literal = (ValaExpression*) _tmp16_;
			_tmp17_ = first;
			if (!_tmp17_) {
				ValadocApiSignatureBuilder* _tmp18_;
				ValadocApiSignatureBuilder* _tmp19_;
				ValadocApiSignatureBuilder* _tmp20_;
				_tmp18_ = self->priv->signature;
				_tmp19_ = valadoc_api_signature_builder_append (_tmp18_, ", ", FALSE);
				_tmp20_ = _tmp19_;
				_valadoc_api_signature_builder_unref0 (_tmp20_);
			}
			_tmp21_ = literal;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
			first = FALSE;
			_vala_code_node_unref0 (literal);
		}
		_vala_iterable_unref0 (_literal_list);
	}
	_tmp22_ = self->priv->signature;
	_tmp23_ = valadoc_api_signature_builder_append (_tmp22_, ")", FALSE);
	_tmp24_ = _tmp23_;
	_valadoc_api_signature_builder_unref0 (_tmp24_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_slice_expression (ValaCodeVisitor* base,
                                                             ValaSliceExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValadocApiSignatureBuilder* _tmp7_;
	ValadocApiSignatureBuilder* _tmp8_;
	ValadocApiSignatureBuilder* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValadocApiSignatureBuilder* _tmp12_;
	ValadocApiSignatureBuilder* _tmp13_;
	ValadocApiSignatureBuilder* _tmp14_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_slice_expression_get_container (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = self->priv->signature;
	_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, "[", FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_tmp5_ = vala_slice_expression_get_start (expr);
	_tmp6_ = _tmp5_;
	vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
	_tmp7_ = self->priv->signature;
	_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, ":", FALSE);
	_tmp9_ = _tmp8_;
	_valadoc_api_signature_builder_unref0 (_tmp9_);
	_tmp10_ = vala_slice_expression_get_stop (expr);
	_tmp11_ = _tmp10_;
	vala_code_node_accept ((ValaCodeNode*) _tmp11_, (ValaCodeVisitor*) self);
	_tmp12_ = self->priv->signature;
	_tmp13_ = valadoc_api_signature_builder_append (_tmp12_, "]", FALSE);
	_tmp14_ = _tmp13_;
	_valadoc_api_signature_builder_unref0 (_tmp14_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_base_access (ValaCodeVisitor* base,
                                                        ValaBaseAccess* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append_keyword (_tmp0_, "base", FALSE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                               ValaPostfixExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = vala_postfix_expression_get_increment (expr);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValadocApiSignatureBuilder* _tmp4_;
		ValadocApiSignatureBuilder* _tmp5_;
		ValadocApiSignatureBuilder* _tmp6_;
		_tmp4_ = self->priv->signature;
		_tmp5_ = valadoc_api_signature_builder_append (_tmp4_, "++", FALSE);
		_tmp6_ = _tmp5_;
		_valadoc_api_signature_builder_unref0 (_tmp6_);
	} else {
		ValadocApiSignatureBuilder* _tmp7_;
		ValadocApiSignatureBuilder* _tmp8_;
		ValadocApiSignatureBuilder* _tmp9_;
		_tmp7_ = self->priv->signature;
		_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, "--", FALSE);
		_tmp9_ = _tmp8_;
		_valadoc_api_signature_builder_unref0 (_tmp9_);
	}
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                                       ValaObjectCreationExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValadocApiSignatureBuilder* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValadocApiSymbol* _tmp8_;
	ValadocApiSymbol* _tmp9_;
	ValadocApiSignatureBuilder* _tmp10_;
	ValadocApiSignatureBuilder* _tmp11_;
	ValadocApiSignatureBuilder* _tmp12_;
	ValadocApiSignatureBuilder* _tmp13_;
	ValadocApiSignatureBuilder* _tmp14_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp30_;
	ValadocApiSignatureBuilder* _tmp31_;
	ValadocApiSignatureBuilder* _tmp32_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_object_creation_expression_get_struct_creation (expr);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		ValadocApiSignatureBuilder* _tmp2_;
		ValadocApiSignatureBuilder* _tmp3_;
		ValadocApiSignatureBuilder* _tmp4_;
		_tmp2_ = self->priv->signature;
		_tmp3_ = valadoc_api_signature_builder_append_keyword (_tmp2_, "new", TRUE);
		_tmp4_ = _tmp3_;
		_valadoc_api_signature_builder_unref0 (_tmp4_);
	}
	_tmp5_ = self->priv->signature;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_api_initializer_builder_resolve (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = valadoc_api_signature_builder_append_symbol (_tmp5_, (ValadocApiNode*) _tmp9_, TRUE);
	_tmp11_ = _tmp10_;
	_valadoc_api_signature_builder_unref0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	_tmp12_ = self->priv->signature;
	_tmp13_ = valadoc_api_signature_builder_append (_tmp12_, " (", FALSE);
	_tmp14_ = _tmp13_;
	_valadoc_api_signature_builder_unref0 (_tmp14_);
	first = TRUE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp15_;
		gint _arg_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _arg_index = 0;
		_tmp15_ = vala_object_creation_expression_get_argument_list (expr);
		_arg_list = _tmp15_;
		_tmp16_ = _arg_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_arg_size = _tmp18_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			ValaExpression* arg = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			gboolean _tmp25_;
			ValaExpression* _tmp29_;
			_tmp19_ = _arg_index;
			_arg_index = _tmp19_ + 1;
			_tmp20_ = _arg_index;
			_tmp21_ = _arg_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _arg_list;
			_tmp23_ = _arg_index;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			arg = (ValaExpression*) _tmp24_;
			_tmp25_ = first;
			if (!_tmp25_) {
				ValadocApiSignatureBuilder* _tmp26_;
				ValadocApiSignatureBuilder* _tmp27_;
				ValadocApiSignatureBuilder* _tmp28_;
				_tmp26_ = self->priv->signature;
				_tmp27_ = valadoc_api_signature_builder_append (_tmp26_, ", ", FALSE);
				_tmp28_ = _tmp27_;
				_valadoc_api_signature_builder_unref0 (_tmp28_);
			}
			_tmp29_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, (ValaCodeVisitor*) self);
			first = FALSE;
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp30_ = self->priv->signature;
	_tmp31_ = valadoc_api_signature_builder_append (_tmp30_, ")", FALSE);
	_tmp32_ = _tmp31_;
	_valadoc_api_signature_builder_unref0 (_tmp32_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                                              ValaSizeofExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValadocApiSignatureBuilder* _tmp7_;
	ValadocApiSignatureBuilder* _tmp8_;
	ValadocApiSignatureBuilder* _tmp9_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append_keyword (_tmp0_, "sizeof", FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, " (", FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp5_ = vala_sizeof_expression_get_type_reference (expr);
	_tmp6_ = _tmp5_;
	valadoc_api_initializer_builder_write_type (self, _tmp6_);
	_tmp7_ = self->priv->signature;
	_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, ")", FALSE);
	_tmp9_ = _tmp8_;
	_valadoc_api_signature_builder_unref0 (_tmp9_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_typeof_expression (ValaCodeVisitor* base,
                                                              ValaTypeofExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValadocApiSignatureBuilder* _tmp7_;
	ValadocApiSignatureBuilder* _tmp8_;
	ValadocApiSignatureBuilder* _tmp9_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append_keyword (_tmp0_, "typeof", FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append (_tmp2_, " (", FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	_tmp5_ = vala_typeof_expression_get_type_reference (expr);
	_tmp6_ = _tmp5_;
	valadoc_api_initializer_builder_write_type (self, _tmp6_);
	_tmp7_ = self->priv->signature;
	_tmp8_ = valadoc_api_signature_builder_append (_tmp7_, ")", FALSE);
	_tmp9_ = _tmp8_;
	_valadoc_api_signature_builder_unref0 (_tmp9_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                              ValaLambdaExpression* expr)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	gboolean first = FALSE;
	ValadocApiSignatureBuilder* _tmp23_;
	ValadocApiSignatureBuilder* _tmp24_;
	ValadocApiSignatureBuilder* _tmp25_;
	ValadocApiSignatureBuilder* _tmp26_;
	ValadocApiSignatureBuilder* _tmp27_;
	ValadocApiSignatureBuilder* _tmp28_;
	ValadocApiSignatureBuilder* _tmp29_;
	ValadocApiSignatureBuilder* _tmp30_;
	ValadocApiSignatureBuilder* _tmp31_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = valadoc_api_signature_builder_append (_tmp0_, "(", FALSE);
	_tmp2_ = _tmp1_;
	_valadoc_api_signature_builder_unref0 (_tmp2_);
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp3_ = vala_lambda_expression_get_parameters (expr);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaParameter* param = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_;
			ValadocApiSignatureBuilder* _tmp17_;
			ValaParameter* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValadocApiSignatureBuilder* _tmp21_;
			ValadocApiSignatureBuilder* _tmp22_;
			_tmp7_ = _param_index;
			_param_index = _tmp7_ + 1;
			_tmp8_ = _param_index;
			_tmp9_ = _param_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _param_list;
			_tmp11_ = _param_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			param = (ValaParameter*) _tmp12_;
			_tmp13_ = first;
			if (!_tmp13_) {
				ValadocApiSignatureBuilder* _tmp14_;
				ValadocApiSignatureBuilder* _tmp15_;
				ValadocApiSignatureBuilder* _tmp16_;
				_tmp14_ = self->priv->signature;
				_tmp15_ = valadoc_api_signature_builder_append (_tmp14_, ", ", FALSE);
				_tmp16_ = _tmp15_;
				_valadoc_api_signature_builder_unref0 (_tmp16_);
			}
			_tmp17_ = self->priv->signature;
			_tmp18_ = param;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = valadoc_api_signature_builder_append (_tmp17_, _tmp20_, FALSE);
			_tmp22_ = _tmp21_;
			_valadoc_api_signature_builder_unref0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp23_ = self->priv->signature;
	_tmp24_ = valadoc_api_signature_builder_append (_tmp23_, ") => {", FALSE);
	_tmp25_ = _tmp24_;
	_valadoc_api_signature_builder_unref0 (_tmp25_);
	_tmp26_ = self->priv->signature;
	_tmp27_ = valadoc_api_signature_builder_append_highlighted (_tmp26_, " [...] ", FALSE);
	_tmp28_ = _tmp27_;
	_valadoc_api_signature_builder_unref0 (_tmp28_);
	_tmp29_ = self->priv->signature;
	_tmp30_ = valadoc_api_signature_builder_append (_tmp29_, "}", FALSE);
	_tmp31_ = _tmp30_;
	_valadoc_api_signature_builder_unref0 (_tmp31_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_boolean_literal (ValaCodeVisitor* base,
                                                            ValaBooleanLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_character_literal (ValaCodeVisitor* base,
                                                              ValaCharacterLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_integer_literal (ValaCodeVisitor* base,
                                                            ValaIntegerLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_real_literal (ValaCodeVisitor* base,
                                                         ValaRealLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_regex_literal (ValaCodeVisitor* base,
                                                          ValaRegexLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_string_literal (ValaCodeVisitor* base,
                                                           ValaStringLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_null_literal (ValaCodeVisitor* base,
                                                         ValaNullLiteral* lit)
{
	ValadocApiInitializerBuilder * self;
	ValadocApiSignatureBuilder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = self->priv->signature;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) lit);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_signature_builder_append_literal (_tmp0_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_valadoc_api_signature_builder_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_field (ValaCodeVisitor* base,
                                                  ValaField* field)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (field != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) field);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_constant (ValaCodeVisitor* base,
                                                     ValaConstant* constant)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (constant != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) constant);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_enum_value (ValaCodeVisitor* base,
                                                       ValaEnumValue* ev)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (ev != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) ev);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_error_code (ValaCodeVisitor* base,
                                                       ValaErrorCode* ec)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (ec != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) ec);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_delegate (ValaCodeVisitor* base,
                                                     ValaDelegate* d)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (d != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) d);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_method (ValaCodeVisitor* base,
                                                   ValaMethod* m)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (m != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) m);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_creation_method (ValaCodeVisitor* base,
                                                            ValaCreationMethod* m)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (m != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) m);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_signal (ValaCodeVisitor* base,
                                                   ValaSignal* sig)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (sig != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) sig);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_class (ValaCodeVisitor* base,
                                                  ValaClass* c)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (c != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) c);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_struct (ValaCodeVisitor* base,
                                                   ValaStruct* s)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (s != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) s);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_interface (ValaCodeVisitor* base,
                                                      ValaInterface* i)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (i != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) i);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_enum (ValaCodeVisitor* base,
                                                 ValaEnum* en)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (en != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) en);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_error_domain (ValaCodeVisitor* base,
                                                         ValaErrorDomain* ed)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (ed != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) ed);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_initializer_builder_real_visit_property (ValaCodeVisitor* base,
                                                     ValaProperty* prop)
{
	ValadocApiInitializerBuilder * self;
	self = (ValadocApiInitializerBuilder*) base;
	g_return_if_fail (prop != NULL);
	valadoc_api_initializer_builder_write_node (self, (ValaSymbol*) prop);
}


static void
valadoc_api_initializer_builder_class_init (ValadocApiInitializerBuilderClass * klass)
{
	valadoc_api_initializer_builder_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = valadoc_api_initializer_builder_finalize;
	g_type_class_add_private (klass, sizeof (ValadocApiInitializerBuilderPrivate));
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor*, ValaArrayCreationExpression*)) valadoc_api_initializer_builder_real_visit_array_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_binary_expression = (void (*) (ValaCodeVisitor*, ValaBinaryExpression*)) valadoc_api_initializer_builder_real_visit_binary_expression;
	((ValaCodeVisitorClass *) klass)->visit_unary_expression = (void (*) (ValaCodeVisitor*, ValaUnaryExpression*)) valadoc_api_initializer_builder_real_visit_unary_expression;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor*, ValaAssignment*)) valadoc_api_initializer_builder_real_visit_assignment;
	((ValaCodeVisitorClass *) klass)->visit_cast_expression = (void (*) (ValaCodeVisitor*, ValaCastExpression*)) valadoc_api_initializer_builder_real_visit_cast_expression;
	((ValaCodeVisitorClass *) klass)->visit_initializer_list = (void (*) (ValaCodeVisitor*, ValaInitializerList*)) valadoc_api_initializer_builder_real_visit_initializer_list;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) valadoc_api_initializer_builder_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) valadoc_api_initializer_builder_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_pointer_indirection = (void (*) (ValaCodeVisitor*, ValaPointerIndirection*)) valadoc_api_initializer_builder_real_visit_pointer_indirection;
	((ValaCodeVisitorClass *) klass)->visit_addressof_expression = (void (*) (ValaCodeVisitor*, ValaAddressofExpression*)) valadoc_api_initializer_builder_real_visit_addressof_expression;
	((ValaCodeVisitorClass *) klass)->visit_reference_transfer_expression = (void (*) (ValaCodeVisitor*, ValaReferenceTransferExpression*)) valadoc_api_initializer_builder_real_visit_reference_transfer_expression;
	((ValaCodeVisitorClass *) klass)->visit_type_check = (void (*) (ValaCodeVisitor*, ValaTypeCheck*)) valadoc_api_initializer_builder_real_visit_type_check;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) valadoc_api_initializer_builder_real_visit_method_call;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor*, ValaSliceExpression*)) valadoc_api_initializer_builder_real_visit_slice_expression;
	((ValaCodeVisitorClass *) klass)->visit_base_access = (void (*) (ValaCodeVisitor*, ValaBaseAccess*)) valadoc_api_initializer_builder_real_visit_base_access;
	((ValaCodeVisitorClass *) klass)->visit_postfix_expression = (void (*) (ValaCodeVisitor*, ValaPostfixExpression*)) valadoc_api_initializer_builder_real_visit_postfix_expression;
	((ValaCodeVisitorClass *) klass)->visit_object_creation_expression = (void (*) (ValaCodeVisitor*, ValaObjectCreationExpression*)) valadoc_api_initializer_builder_real_visit_object_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_sizeof_expression = (void (*) (ValaCodeVisitor*, ValaSizeofExpression*)) valadoc_api_initializer_builder_real_visit_sizeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_typeof_expression = (void (*) (ValaCodeVisitor*, ValaTypeofExpression*)) valadoc_api_initializer_builder_real_visit_typeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) valadoc_api_initializer_builder_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_boolean_literal = (void (*) (ValaCodeVisitor*, ValaBooleanLiteral*)) valadoc_api_initializer_builder_real_visit_boolean_literal;
	((ValaCodeVisitorClass *) klass)->visit_character_literal = (void (*) (ValaCodeVisitor*, ValaCharacterLiteral*)) valadoc_api_initializer_builder_real_visit_character_literal;
	((ValaCodeVisitorClass *) klass)->visit_integer_literal = (void (*) (ValaCodeVisitor*, ValaIntegerLiteral*)) valadoc_api_initializer_builder_real_visit_integer_literal;
	((ValaCodeVisitorClass *) klass)->visit_real_literal = (void (*) (ValaCodeVisitor*, ValaRealLiteral*)) valadoc_api_initializer_builder_real_visit_real_literal;
	((ValaCodeVisitorClass *) klass)->visit_regex_literal = (void (*) (ValaCodeVisitor*, ValaRegexLiteral*)) valadoc_api_initializer_builder_real_visit_regex_literal;
	((ValaCodeVisitorClass *) klass)->visit_string_literal = (void (*) (ValaCodeVisitor*, ValaStringLiteral*)) valadoc_api_initializer_builder_real_visit_string_literal;
	((ValaCodeVisitorClass *) klass)->visit_null_literal = (void (*) (ValaCodeVisitor*, ValaNullLiteral*)) valadoc_api_initializer_builder_real_visit_null_literal;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) valadoc_api_initializer_builder_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) valadoc_api_initializer_builder_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor*, ValaEnumValue*)) valadoc_api_initializer_builder_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor*, ValaErrorCode*)) valadoc_api_initializer_builder_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) valadoc_api_initializer_builder_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) valadoc_api_initializer_builder_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) valadoc_api_initializer_builder_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) valadoc_api_initializer_builder_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) valadoc_api_initializer_builder_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) valadoc_api_initializer_builder_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) valadoc_api_initializer_builder_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) valadoc_api_initializer_builder_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) valadoc_api_initializer_builder_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) valadoc_api_initializer_builder_real_visit_property;
}


static void
valadoc_api_initializer_builder_instance_init (ValadocApiInitializerBuilder * self)
{
	self->priv = VALADOC_API_INITIALIZER_BUILDER_GET_PRIVATE (self);
}


static void
valadoc_api_initializer_builder_finalize (ValaCodeVisitor * obj)
{
	ValadocApiInitializerBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_INITIALIZER_BUILDER, ValadocApiInitializerBuilder);
	_vala_map_unref0 (self->priv->symbol_map);
	_valadoc_api_signature_builder_unref0 (self->priv->signature);
	VALA_CODE_VISITOR_CLASS (valadoc_api_initializer_builder_parent_class)->finalize (obj);
}


G_GNUC_INTERNAL GType
valadoc_api_initializer_builder_get_type (void)
{
	static volatile gsize valadoc_api_initializer_builder_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_initializer_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiInitializerBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_initializer_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiInitializerBuilder), 0, (GInstanceInitFunc) valadoc_api_initializer_builder_instance_init, NULL };
		GType valadoc_api_initializer_builder_type_id;
		valadoc_api_initializer_builder_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValadocApiInitializerBuilder", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_api_initializer_builder_type_id__volatile, valadoc_api_initializer_builder_type_id);
	}
	return valadoc_api_initializer_builder_type_id__volatile;
}



