/*
 * ===========================
 * VDK Builder
 * Version 0.1.1 
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_dialogs_h
#define _vdkb_dialogs_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>
// setting property dialogs base class
class VDKBPropDialog: public VDKForm
{
 protected:
  VDKBObject* active;
 public:
    VDKBPropDialog(VDKForm* owner, VDKBObject* active,
	       char* title = "", 
#ifdef HAVE_VDKDEVEL
		     VDKBoxType mode = v_box,
#else
		     int mode = v_box,
#endif
	       GtkWindowType display = GTK_WINDOW_TOPLEVEL):
      VDKForm(owner,title,mode,display),active(active) {}
    virtual ~VDKBPropDialog() {}
};

// setting size
class VDKBPropSizeDialog: public VDKBPropDialog
{
 protected:
  VDKSpinButton *hspin,*vspin;
  VDKCustomButton* quit,*reset;
  
 public:
  VDKBPropSizeDialog(VDKForm* owner, 
		     VDKBObject* active,
		     char* title = "", 
#ifdef HAVE_VDKDEVEL
		     VDKBoxType mode = v_box,
#else
		     int mode = v_box,
#endif
		     GtkWindowType display = GTK_WINDOW_TOPLEVEL):
    VDKBPropDialog(owner,active,title,mode,display)
    {}
  virtual ~VDKBPropSizeDialog() {}
  void Setup();
  bool OnChange(VDKObject* sender);
  bool OnReset(VDKObject* sender);
  DECLARE_SIGNAL_MAP(VDKBPropSizeDialog);
};
#endif
