// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLSL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_UMLSL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_umlsl2_2D[] = {
  0xffffc002fff70000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff800300, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xfffffffff0006000, 0x0000000000000001,
  0xffffffffc1817700, 0x0000000000000001,
  0xffffffffc1017a00, 0x0000000000000001,
  0xffffffffc0817d00, 0x0000000000000001,
  0xffffffc002fff700, 0x0000000000000001,
  0xffffffc0027ffa00, 0x0000000000000001,
  0xffffffc001fffd00, 0x0000000000000001,
  0xffe6670000199900, 0x0000000000000001,
  0xffd55655557fff00, 0x0000000000000001,
  0xffc00180017ff700, 0x0000000000000001,
  0xffc0018000fffa00, 0x0000000000000001,
  0xffc00180007ffd00, 0x0000000000000001,
  0xffc0018000000000, 0x0000000000000001,
  0xffc0017fff800300, 0x0000000000000001,
  0xffaaacaaaafffe00, 0x0000000000000001,
  0xff999c0000666400, 0x0000000000000001,
  0xff80033ffe800000, 0x0000000000000001,
  0xff80033ffe000300, 0x0000000000000001,
  0xff80033ffd800600, 0x0000000000000001,
  0xff80033ffd000900, 0x0000000000000001,
  0xff8003003ffe8000, 0x0000000000000001,
  0xff8003003f7e8300, 0x0000000000000001,
  0xff8003003efe8600, 0x0000000000000001,
  0xff8003003e7e8900, 0x0000000000000001,
  0xff8003000fffa000, 0x0000000000000001,
  0xff800300017ff700, 0x0000000000000001,
  0xff80030000fffa00, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffe1,
  0x0000000000000000, 0xffffffffffffff84,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffff8004,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffccccccce,
  0x0000000000000000, 0xffffffffaaaaaaac,
  0x0000000000000000, 0xffffffff80000004,
  0x0000000000000000, 0xffffffff80000003,
  0x0000000000000000, 0xffffffff80000002,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff55555557,
  0x0000000000000000, 0xffffffff33333335,
  0x0000000000000000, 0xffffffff00008001,
  0x0000000000000000, 0xffffffff00008000,
  0x0000000000000000, 0xffffffff00007fff,
  0x0000000000000000, 0xffffffff00007ffe,
  0x0000000000000000, 0xffffffff00000081,
  0x0000000000000000, 0xffffffff00000080,
  0x0000000000000000, 0xffffffff0000007f,
  0x0000000000000000, 0xffffffff0000007e,
  0x0000000000000000, 0xffffffff00000021,
  0x0000000000000000, 0xffffffff00000004,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0xffffffff00000002,
  0xffffffff00000001, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0xffffffffffffffc1,
  0xffffffffffffffe0, 0xffffffffffffff07,
  0xffffffffffffff83, 0xffffffffffffff05,
  0xffffffffffffff82, 0xffffffffffffff03,
  0xffffffffffffff81, 0xffffffffffff0007,
  0xffffffffffff8003, 0xffffffffffff0005,
  0xffffffffffff8002, 0xffffffffffff0003,
  0xffffffffffff8001, 0xffffffff9999999b,
  0xffffffffcccccccd, 0xffffffff55555557,
  0xffffffffaaaaaaab, 0xffffffff00000007,
  0xffffffff80000003, 0xffffffff00000005,
  0xffffffff80000002, 0xffffffff00000003,
  0xffffffff80000001, 0xffffffff00000001,
  0xffffffff80000000, 0xfffffffeffffffff,
  0xffffffff7fffffff, 0xfffffffeaaaaaaad,
  0xffffffff55555556, 0xfffffffe66666669,
  0xffffffff33333334, 0xfffffffe00010001,
  0xffffffff00008000, 0xfffffffe0000ffff,
  0xffffffff00007fff, 0xfffffffe0000fffd,
  0xffffffff00007ffe, 0xfffffffe0000fffb,
  0xffffffff00007ffd, 0xfffffffe00000101,
  0xffffffff00000080, 0xfffffffe000000ff,
  0xffffffff0000007f, 0xfffffffe000000fd,
  0xffffffff0000007e, 0xfffffffe000000fb,
  0xffffffff0000007d, 0xfffffffe00000041,
  0xffffffff00000020, 0xfffffffe00000007,
  0xffffffff00000003, 0xfffffffe00000005,
  0xffffffff00000002, 0xfffffffe00000003,
  0xfffffffe00000002, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffe1,
  0xfffffffffffffffe, 0xffffffffffffffc1,
  0xfffffffffffffffc, 0xfffffffffffffc01,
  0xffffffffffffffc0, 0xfffffffffffff061,
  0xffffffffffffff06, 0xfffffffffffff041,
  0xffffffffffffff04, 0xfffffffffffff021,
  0xffffffffffffff02, 0xfffffffffff00061,
  0xffffffffffff0006, 0xfffffffffff00041,
  0xffffffffffff0004, 0xfffffffffff00021,
  0xffffffffffff0002, 0xfffffff9999999a1,
  0xffffffff9999999a, 0xfffffff555555561,
  0xffffffff55555556, 0xfffffff000000061,
  0xffffffff00000006, 0xfffffff000000041,
  0xffffffff00000004, 0xfffffff000000021,
  0xffffffff00000002, 0xfffffff000000001,
  0xffffffff00000000, 0xffffffefffffffe1,
  0xfffffffefffffffe, 0xffffffeaaaaaaac1,
  0xfffffffeaaaaaaac, 0xffffffe666666681,
  0xfffffffe66666668, 0xffffffe000100001,
  0xfffffffe00010000, 0xffffffe0000fffe1,
  0xfffffffe0000fffe, 0xffffffe0000fffc1,
  0xfffffffe0000fffc, 0xffffffe0000fffa1,
  0xfffffffe0000fffa, 0xffffffe000001001,
  0xfffffffe00000100, 0xffffffe000000fe1,
  0xfffffffe000000fe, 0xffffffe000000fc1,
  0xfffffffe000000fc, 0xffffffe000000fa1,
  0xfffffffe000000fa, 0xffffffe000000401,
  0xfffffffe00000040, 0xffffffe000000061,
  0xfffffffe00000006, 0xffffffe000000041,
  0xfffffffe00000004, 0xffffffe000000021,
  0xffffffe000000020, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff84,
  0xffffffffffffffe0, 0xffffffffffffff07,
  0xffffffffffffffc0, 0xfffffffffffff061,
  0xfffffffffffffc00, 0xffffffffffffc2f8,
  0xfffffffffffff060, 0xffffffffffffc27b,
  0xfffffffffffff040, 0xffffffffffffc1fe,
  0xfffffffffffff020, 0xffffffffffc18178,
  0xfffffffffff00060, 0xffffffffffc180fb,
  0xfffffffffff00040, 0xffffffffffc1807e,
  0xfffffffffff00020, 0xffffffe70000001a,
  0xfffffff9999999a0, 0xffffffd655555580,
  0xfffffff555555560, 0xffffffc180000178,
  0xfffffff000000060, 0xffffffc1800000fb,
  0xfffffff000000040, 0xffffffc18000007e,
  0xfffffff000000020, 0xffffffc180000001,
  0xfffffff000000000, 0xffffffc17fffff84,
  0xffffffefffffffe0, 0xffffffacaaaaaaff,
  0xffffffeaaaaaaac0, 0xffffff9c00000065,
  0xffffffe666666680, 0xffffff83003e8001,
  0xffffffe000100000, 0xffffff83003e7f84,
  0xffffffe0000fffe0, 0xffffff83003e7f07,
  0xffffffe0000fffc0, 0xffffff83003e7e8a,
  0xffffffe0000fffa0, 0xffffff8300003e81,
  0xffffffe000001000, 0xffffff8300003e04,
  0xffffffe000000fe0, 0xffffff8300003d87,
  0xffffffe000000fc0, 0xffffff8300003d0a,
  0xffffffe000000fa0, 0xffffff8300000fa1,
  0xffffffe000000400, 0xffffff8300000178,
  0xffffffe000000060, 0xffffff83000000fb,
  0xffffffe000000040, 0xffffff830000007e,
  0xffffff830000007d, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff83,
  0xffffffffffffff83, 0xffffffffffffff05,
  0xffffffffffffff06, 0xfffffffffffff041,
  0xfffffffffffff060, 0xffffffffffffc27b,
  0xffffffffffffc2f7, 0xffffffffffffc1fd,
  0xffffffffffffc27a, 0xffffffffffffc17f,
  0xffffffffffffc1fd, 0xffffffffffc1017b,
  0xffffffffffc18177, 0xffffffffffc100fd,
  0xffffffffffc180fa, 0xffffffffffc1007f,
  0xffffffffffc1807d, 0xffffffe6cccccce7,
  0xffffffe700000019, 0xffffffd60000002b,
  0xffffffd65555557f, 0xffffffc10000017b,
  0xffffffc180000177, 0xffffffc1000000fd,
  0xffffffc1800000fa, 0xffffffc10000007f,
  0xffffffc18000007d, 0xffffffc100000001,
  0xffffffc180000000, 0xffffffc0ffffff83,
  0xffffffc17fffff83, 0xffffffac00000055,
  0xffffffacaaaaaafe, 0xffffff9b33333399,
  0xffffff9c00000064, 0xffffff82003f0001,
  0xffffff83003e8000, 0xffffff82003eff83,
  0xffffff83003e7f83, 0xffffff82003eff05,
  0xffffff83003e7f06, 0xffffff82003efe87,
  0xffffff83003e7e89, 0xffffff8200003f01,
  0xffffff8300003e80, 0xffffff8200003e83,
  0xffffff8300003e03, 0xffffff8200003e05,
  0xffffff8300003d86, 0xffffff8200003d87,
  0xffffff8300003d09, 0xffffff8200000fc1,
  0xffffff8300000fa0, 0xffffff820000017b,
  0xffffff8300000177, 0xffffff82000000fd,
  0xffffff83000000fa, 0xffffff820000007f,
  0xffffff820000007e, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff82,
  0xffffffffffffff82, 0xffffffffffffff03,
  0xffffffffffffff04, 0xfffffffffffff021,
  0xfffffffffffff040, 0xffffffffffffc1fe,
  0xffffffffffffc27a, 0xffffffffffffc17f,
  0xffffffffffffc1fc, 0xffffffffffffc100,
  0xffffffffffffc17e, 0xffffffffffc0817e,
  0xffffffffffc1017a, 0xffffffffffc080ff,
  0xffffffffffc100fc, 0xffffffffffc08080,
  0xffffffffffc1007e, 0xffffffe6999999b4,
  0xffffffe6cccccce6, 0xffffffd5aaaaaad6,
  0xffffffd60000002a, 0xffffffc08000017e,
  0xffffffc10000017a, 0xffffffc0800000ff,
  0xffffffc1000000fc, 0xffffffc080000080,
  0xffffffc10000007e, 0xffffffc080000001,
  0xffffffc100000000, 0xffffffc07fffff82,
  0xffffffc0ffffff82, 0xffffffab555555ab,
  0xffffffac00000054, 0xffffff9a666666cd,
  0xffffff9b33333398, 0xffffff81003f8001,
  0xffffff82003f0000, 0xffffff81003f7f82,
  0xffffff82003eff82, 0xffffff81003f7f03,
  0xffffff82003eff04, 0xffffff81003f7e84,
  0xffffff82003efe86, 0xffffff8100003f81,
  0xffffff8200003f00, 0xffffff8100003f02,
  0xffffff8200003e82, 0xffffff8100003e83,
  0xffffff8200003e04, 0xffffff8100003e04,
  0xffffff8200003d86, 0xffffff8100000fe1,
  0xffffff8200000fc0, 0xffffff810000017e,
  0xffffff820000017a, 0xffffff81000000ff,
  0xffffff82000000fc, 0xffffff8100000080,
  0xffffff810000007f, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8004,
  0xffffffffffffff81, 0xffffffffffff0007,
  0xffffffffffffff02, 0xfffffffffff00061,
  0xfffffffffffff020, 0xffffffffffc18178,
  0xffffffffffffc1fd, 0xffffffffffc1017b,
  0xffffffffffffc17e, 0xffffffffffc0817e,
  0xffffffffffffc0ff, 0xffffffffc002fff8,
  0xffffffffffc0817d, 0xffffffffc0027ffb,
  0xffffffffffc080fe, 0xffffffffc001fffe,
  0xffffffffffc0807f, 0xffffe6670000199a,
  0xffffffe6999999b3, 0xffffd55655558000,
  0xffffffd5aaaaaad5, 0xffffc00180017ff8,
  0xffffffc08000017d, 0xffffc0018000fffb,
  0xffffffc0800000fe, 0xffffc00180007ffe,
  0xffffffc08000007f, 0xffffc00180000001,
  0xffffffc080000000, 0xffffc0017fff8004,
  0xffffffc07fffff81, 0xffffaaacaaaaffff,
  0xffffffab555555aa, 0xffff999c00006665,
  0xffffff9a666666cc, 0xffff80033ffe8001,
  0xffffff81003f8000, 0xffff80033ffe0004,
  0xffffff81003f7f81, 0xffff80033ffd8007,
  0xffffff81003f7f02, 0xffff80033ffd000a,
  0xffffff81003f7e83, 0xffff8003003ffe81,
  0xffffff8100003f80, 0xffff8003003f7e84,
  0xffffff8100003f01, 0xffff8003003efe87,
  0xffffff8100003e82, 0xffff8003003e7e8a,
  0xffffff8100003e03, 0xffff8003000fffa1,
  0xffffff8100000fe0, 0xffff800300017ff8,
  0xffffff810000017d, 0xffff80030000fffb,
  0xffffff81000000fe, 0xffff800300007ffe,
  0xffff800300007ffd, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8003,
  0xffffffffffff8003, 0xffffffffffff0005,
  0xffffffffffff0006, 0xfffffffffff00041,
  0xfffffffffff00060, 0xffffffffffc180fb,
  0xffffffffffc18177, 0xffffffffffc100fd,
  0xffffffffffc1017a, 0xffffffffffc080ff,
  0xffffffffffc0817d, 0xffffffffc0027ffb,
  0xffffffffc002fff7, 0xffffffffc001fffd,
  0xffffffffc0027ffa, 0xffffffffc0017fff,
  0xffffffffc001fffd, 0xffffe666cccce667,
  0xffffe66700001999, 0xffffd55600002aab,
  0xffffd55655557fff, 0xffffc00100017ffb,
  0xffffc00180017ff7, 0xffffc0010000fffd,
  0xffffc0018000fffa, 0xffffc00100007fff,
  0xffffc00180007ffd, 0xffffc00100000001,
  0xffffc00180000000, 0xffffc000ffff8003,
  0xffffc0017fff8003, 0xffffaaac00005555,
  0xffffaaacaaaafffe, 0xffff999b33339999,
  0xffff999c00006664, 0xffff80023fff0001,
  0xffff80033ffe8000, 0xffff80023ffe8003,
  0xffff80033ffe0003, 0xffff80023ffe0005,
  0xffff80033ffd8006, 0xffff80023ffd8007,
  0xffff80033ffd0009, 0xffff8002003fff01,
  0xffff8003003ffe80, 0xffff8002003f7f03,
  0xffff8003003f7e83, 0xffff8002003eff05,
  0xffff8003003efe86, 0xffff8002003e7f07,
  0xffff8003003e7e89, 0xffff8002000fffc1,
  0xffff8003000fffa0, 0xffff800200017ffb,
  0xffff800300017ff7, 0xffff80020000fffd,
  0xffff80030000fffa, 0xffff800200007fff,
  0xffff800200007ffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8002,
  0xffffffffffff8002, 0xffffffffffff0003,
  0xffffffffffff0004, 0xfffffffffff00021,
  0xfffffffffff00040, 0xffffffffffc1807e,
  0xffffffffffc180fa, 0xffffffffffc1007f,
  0xffffffffffc100fc, 0xffffffffffc08080,
  0xffffffffffc080fe, 0xffffffffc001fffe,
  0xffffffffc0027ffa, 0xffffffffc0017fff,
  0xffffffffc001fffc, 0xffffffffc0010000,
  0xffffffffc0017ffe, 0xffffe6669999b334,
  0xffffe666cccce666, 0xffffd555aaaad556,
  0xffffd55600002aaa, 0xffffc00080017ffe,
  0xffffc00100017ffa, 0xffffc0008000ffff,
  0xffffc0010000fffc, 0xffffc00080008000,
  0xffffc00100007ffe, 0xffffc00080000001,
  0xffffc00100000000, 0xffffc0007fff8002,
  0xffffc000ffff8002, 0xffffaaab5555aaab,
  0xffffaaac00005554, 0xffff999a6666cccd,
  0xffff999b33339998, 0xffff80013fff8001,
  0xffff80023fff0000, 0xffff80013fff0002,
  0xffff80023ffe8002, 0xffff80013ffe8003,
  0xffff80023ffe0004, 0xffff80013ffe0004,
  0xffff80023ffd8006, 0xffff8001003fff81,
  0xffff8002003fff00, 0xffff8001003f7f82,
  0xffff8002003f7f02, 0xffff8001003eff83,
  0xffff8002003eff04, 0xffff8001003e7f84,
  0xffff8002003e7f06, 0xffff8001000fffe1,
  0xffff8002000fffc0, 0xffff800100017ffe,
  0xffff800200017ffa, 0xffff80010000ffff,
  0xffff80020000fffc, 0xffff800100008000,
  0xffff800100007fff, 0x0000000000000001,
  0x0000000000000000, 0xffffffffccccccce,
  0xffffffffffff8001, 0xffffffff9999999b,
  0xffffffffffff0002, 0xfffffff9999999a1,
  0xfffffffffff00020, 0xffffffe70000001a,
  0xffffffffffc1807d, 0xffffffe6cccccce7,
  0xffffffffffc1007e, 0xffffffe6999999b4,
  0xffffffffffc0807f, 0xffffe6670000199a,
  0xffffffffc001fffd, 0xffffe666cccce667,
  0xffffffffc0017ffe, 0xffffe6669999b334,
  0xffffffffc000ffff, 0xf5c28f5c3d70a3d8,
  0xffffe6669999b333, 0xeeeeeeef11111112,
  0xffffd555aaaad555, 0xe66666671999999a,
  0xffffc00080017ffd, 0xe6666666e6666667,
  0xffffc0008000fffe, 0xe6666666b3333334,
  0xffffc00080007fff, 0xe666666680000001,
  0xffffc00080000000, 0xe66666664cccccce,
  0xffffc0007fff8001, 0xddddddde22222223,
  0xffffaaab5555aaaa, 0xd70a3d70f5c28f5d,
  0xffff999a6666cccc, 0xcccce66699998001,
  0xffff80013fff8000, 0xcccce66666664cce,
  0xffff80013fff0001, 0xcccce6663333199b,
  0xffff80013ffe8002, 0xcccce665ffffe668,
  0xffff80013ffe0003, 0xcccccce699999981,
  0xffff8001003fff80, 0xcccccce66666664e,
  0xffff8001003f7f81, 0xcccccce63333331b,
  0xffff8001003eff82, 0xcccccce5ffffffe8,
  0xffff8001003e7f83, 0xccccccd366666661,
  0xffff8001000fffe0, 0xcccccccd9999999a,
  0xffff800100017ffd, 0xcccccccd66666667,
  0xffff80010000fffe, 0xcccccccd33333334,
  0xcccccccd33333333, 0x0000000000000001,
  0x0000000000000000, 0xffffffffaaaaaaac,
  0xffffffffcccccccd, 0xffffffff55555557,
  0xffffffff9999999a, 0xfffffff555555561,
  0xfffffff9999999a0, 0xffffffd655555580,
  0xffffffe700000019, 0xffffffd60000002b,
  0xffffffe6cccccce6, 0xffffffd5aaaaaad6,
  0xffffffe6999999b3, 0xffffd55655558000,
  0xffffe66700001999, 0xffffd55600002aab,
  0xffffe666cccce666, 0xffffd555aaaad556,
  0xffffe6669999b333, 0xeeeeeeef11111112,
  0xf5c28f5c3d70a3d7, 0xe38e38e3c71c71c8,
  0xeeeeeeef11111111, 0xd555555680000000,
  0xe666666719999999, 0xd55555562aaaaaab,
  0xe6666666e6666666, 0xd5555555d5555556,
  0xe6666666b3333333, 0xd555555580000001,
  0xe666666680000000, 0xd55555552aaaaaac,
  0xe66666664ccccccd, 0xc71c71c78e38e38f,
  0xddddddde22222222, 0xbbbbbbbc44444445,
  0xd70a3d70f5c28f5c, 0xaaaad555aaaa8001,
  0xcccce66699998000, 0xaaaad55555552aac,
  0xcccce66666664ccd, 0xaaaad554ffffd557,
  0xcccce6663333199a, 0xaaaad554aaaa8002,
  0xcccce665ffffe667, 0xaaaaaad5aaaaaa81,
  0xcccccce699999980, 0xaaaaaad55555552c,
  0xcccccce66666664d, 0xaaaaaad4ffffffd7,
  0xcccccce63333331a, 0xaaaaaad4aaaaaa82,
  0xcccccce5ffffffe7, 0xaaaaaab5aaaaaaa1,
  0xccccccd366666660, 0xaaaaaaac00000000,
  0xcccccccd99999999, 0xaaaaaaabaaaaaaab,
  0xcccccccd66666666, 0xaaaaaaab55555556,
  0xaaaaaaab55555555, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000004,
  0xffffffffaaaaaaab, 0xffffffff00000007,
  0xffffffff55555556, 0xfffffff000000061,
  0xfffffff555555560, 0xffffffc180000178,
  0xffffffd65555557f, 0xffffffc10000017b,
  0xffffffd60000002a, 0xffffffc08000017e,
  0xffffffd5aaaaaad5, 0xffffc00180017ff8,
  0xffffd55655557fff, 0xffffc00100017ffb,
  0xffffd55600002aaa, 0xffffc00080017ffe,
  0xffffd555aaaad555, 0xe66666671999999a,
  0xeeeeeeef11111111, 0xd555555680000000,
  0xe38e38e3c71c71c7, 0xc0000002fffffff8,
  0xd55555567fffffff, 0xc00000027ffffffb,
  0xd55555562aaaaaaa, 0xc0000001fffffffe,
  0xd5555555d5555555, 0xc000000180000001,
  0xd555555580000000, 0xc000000100000004,
  0xd55555552aaaaaab, 0xaaaaaaacffffffff,
  0xc71c71c78e38e38e, 0x9999999c66666665,
  0xbbbbbbbc44444444, 0x80004002fffe8001,
  0xaaaad555aaaa8000, 0x800040027ffe8004,
  0xaaaad55555552aab, 0x80004001fffe8007,
  0xaaaad554ffffd556, 0x800040017ffe800a,
  0xaaaad554aaaa8001, 0x80000042fffffe81,
  0xaaaaaad5aaaaaa80, 0x800000427ffffe84,
  0xaaaaaad55555552b, 0x80000041fffffe87,
  0xaaaaaad4ffffffd6, 0x800000417ffffe8a,
  0xaaaaaad4aaaaaa81, 0x80000012ffffffa1,
  0xaaaaaab5aaaaaaa0, 0x800000047ffffff8,
  0xaaaaaaabffffffff, 0x80000003fffffffb,
  0xaaaaaaabaaaaaaaa, 0x800000037ffffffe,
  0x800000037ffffffd, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000003,
  0xffffffff80000003, 0xffffffff00000005,
  0xffffffff00000006, 0xfffffff000000041,
  0xfffffff000000060, 0xffffffc1800000fb,
  0xffffffc180000177, 0xffffffc1000000fd,
  0xffffffc10000017a, 0xffffffc0800000ff,
  0xffffffc08000017d, 0xffffc0018000fffb,
  0xffffc00180017ff7, 0xffffc0010000fffd,
  0xffffc00100017ffa, 0xffffc0008000ffff,
  0xffffc00080017ffd, 0xe6666666e6666667,
  0xe666666719999999, 0xd55555562aaaaaab,
  0xd55555567fffffff, 0xc00000027ffffffb,
  0xc0000002fffffff7, 0xc0000001fffffffd,
  0xc00000027ffffffa, 0xc00000017fffffff,
  0xc0000001fffffffd, 0xc000000100000001,
  0xc000000180000000, 0xc000000080000003,
  0xc000000100000003, 0xaaaaaaac55555555,
  0xaaaaaaacfffffffe, 0x9999999b99999999,
  0x9999999c66666664, 0x80004001ffff0001,
  0x80004002fffe8000, 0x800040017fff0003,
  0x800040027ffe8003, 0x80004000ffff0005,
  0x80004001fffe8006, 0x800040007fff0007,
  0x800040017ffe8009, 0x80000041ffffff01,
  0x80000042fffffe80, 0x800000417fffff03,
  0x800000427ffffe83, 0x80000040ffffff05,
  0x80000041fffffe86, 0x800000407fffff07,
  0x800000417ffffe89, 0x80000011ffffffc1,
  0x80000012ffffffa0, 0x800000037ffffffb,
  0x800000047ffffff7, 0x80000002fffffffd,
  0x80000003fffffffa, 0x800000027fffffff,
  0x800000027ffffffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000002,
  0xffffffff80000002, 0xffffffff00000003,
  0xffffffff00000004, 0xfffffff000000021,
  0xfffffff000000040, 0xffffffc18000007e,
  0xffffffc1800000fa, 0xffffffc10000007f,
  0xffffffc1000000fc, 0xffffffc080000080,
  0xffffffc0800000fe, 0xffffc00180007ffe,
  0xffffc0018000fffa, 0xffffc00100007fff,
  0xffffc0010000fffc, 0xffffc00080008000,
  0xffffc0008000fffe, 0xe6666666b3333334,
  0xe6666666e6666666, 0xd5555555d5555556,
  0xd55555562aaaaaaa, 0xc0000001fffffffe,
  0xc00000027ffffffa, 0xc00000017fffffff,
  0xc0000001fffffffc, 0xc000000100000000,
  0xc00000017ffffffe, 0xc000000080000001,
  0xc000000100000000, 0xc000000000000002,
  0xc000000080000002, 0xaaaaaaabaaaaaaab,
  0xaaaaaaac55555554, 0x9999999acccccccd,
  0x9999999b99999998, 0x80004000ffff8001,
  0x80004001ffff0000, 0x800040007fff8002,
  0x800040017fff0002, 0x80003fffffff8003,
  0x80004000ffff0004, 0x80003fff7fff8004,
  0x800040007fff0006, 0x80000040ffffff81,
  0x80000041ffffff00, 0x800000407fffff82,
  0x800000417fffff02, 0x8000003fffffff83,
  0x80000040ffffff04, 0x8000003f7fffff84,
  0x800000407fffff06, 0x80000010ffffffe1,
  0x80000011ffffffc0, 0x800000027ffffffe,
  0x800000037ffffffa, 0x80000001ffffffff,
  0x80000002fffffffc, 0x8000000180000000,
  0x800000017fffffff, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000001,
  0xffffffff80000001, 0xffffffff00000001,
  0xffffffff00000002, 0xfffffff000000001,
  0xfffffff000000020, 0xffffffc180000001,
  0xffffffc18000007d, 0xffffffc100000001,
  0xffffffc10000007e, 0xffffffc080000001,
  0xffffffc08000007f, 0xffffc00180000001,
  0xffffc00180007ffd, 0xffffc00100000001,
  0xffffc00100007ffe, 0xffffc00080000001,
  0xffffc00080007fff, 0xe666666680000001,
  0xe6666666b3333333, 0xd555555580000001,
  0xd5555555d5555555, 0xc000000180000001,
  0xc0000001fffffffd, 0xc000000100000001,
  0xc00000017ffffffe, 0xc000000080000001,
  0xc0000000ffffffff, 0xc000000000000001,
  0xc000000080000000, 0xbfffffff80000001,
  0xc000000000000001, 0xaaaaaaab00000001,
  0xaaaaaaabaaaaaaaa, 0x9999999a00000001,
  0x9999999acccccccc, 0x8000400000000001,
  0x80004000ffff8000, 0x80003fff80000001,
  0x800040007fff8001, 0x80003fff00000001,
  0x80003fffffff8002, 0x80003ffe80000001,
  0x80003fff7fff8003, 0x8000004000000001,
  0x80000040ffffff80, 0x8000003f80000001,
  0x800000407fffff81, 0x8000003f00000001,
  0x8000003fffffff82, 0x8000003e80000001,
  0x8000003f7fffff83, 0x8000001000000001,
  0x80000010ffffffe0, 0x8000000180000001,
  0x800000027ffffffd, 0x8000000100000001,
  0x80000001fffffffe, 0x8000000080000001,
  0x8000000080000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000000,
  0xffffffff80000000, 0xfffffffeffffffff,
  0xffffffff00000000, 0xffffffefffffffe1,
  0xfffffff000000000, 0xffffffc17fffff84,
  0xffffffc180000000, 0xffffffc0ffffff83,
  0xffffffc100000000, 0xffffffc07fffff82,
  0xffffffc080000000, 0xffffc0017fff8004,
  0xffffc00180000000, 0xffffc000ffff8003,
  0xffffc00100000000, 0xffffc0007fff8002,
  0xffffc00080000000, 0xe66666664cccccce,
  0xe666666680000000, 0xd55555552aaaaaac,
  0xd555555580000000, 0xc000000100000004,
  0xc000000180000000, 0xc000000080000003,
  0xc000000100000000, 0xc000000000000002,
  0xc000000080000000, 0xbfffffff80000001,
  0xc000000000000000, 0xbfffffff00000000,
  0xbfffffff80000000, 0xaaaaaaaa55555557,
  0xaaaaaaab00000000, 0x9999999933333335,
  0x9999999a00000000, 0x80003fff00008001,
  0x8000400000000000, 0x80003ffe80008000,
  0x80003fff80000000, 0x80003ffe00007fff,
  0x80003fff00000000, 0x80003ffd80007ffe,
  0x80003ffe80000000, 0x8000003f00000081,
  0x8000004000000000, 0x8000003e80000080,
  0x8000003f80000000, 0x8000003e0000007f,
  0x8000003f00000000, 0x8000003d8000007e,
  0x8000003e80000000, 0x8000000f00000021,
  0x8000001000000000, 0x8000000080000004,
  0x8000000180000000, 0x8000000000000003,
  0x8000000100000000, 0x7fffffff80000002,
  0x7fffffff80000001, 0x0000000000000001,
  0x0000000000000000, 0xffffffff55555557,
  0xffffffff7fffffff, 0xfffffffeaaaaaaad,
  0xfffffffefffffffe, 0xffffffeaaaaaaac1,
  0xffffffefffffffe0, 0xffffffacaaaaaaff,
  0xffffffc17fffff83, 0xffffffac00000055,
  0xffffffc0ffffff82, 0xffffffab555555ab,
  0xffffffc07fffff81, 0xffffaaacaaaaffff,
  0xffffc0017fff8003, 0xffffaaac00005555,
  0xffffc000ffff8002, 0xffffaaab5555aaab,
  0xffffc0007fff8001, 0xddddddde22222223,
  0xe66666664ccccccd, 0xc71c71c78e38e38f,
  0xd55555552aaaaaab, 0xaaaaaaacffffffff,
  0xc000000100000003, 0xaaaaaaac55555555,
  0xc000000080000002, 0xaaaaaaabaaaaaaab,
  0xc000000000000001, 0xaaaaaaab00000001,
  0xbfffffff80000000, 0xaaaaaaaa55555557,
  0xbffffffeffffffff, 0x8e38e38f1c71c71d,
  0xaaaaaaaa55555556, 0x7777777888888889,
  0x9999999933333334, 0x5555aaab55550001,
  0x80003fff00008000, 0x5555aaaaaaaa5557,
  0x80003ffe80007fff, 0x5555aaa9ffffaaad,
  0x80003ffe00007ffe, 0x5555aaa955550003,
  0x80003ffd80007ffd, 0x555555ab55555501,
  0x8000003f00000080, 0x555555aaaaaaaa57,
  0x8000003e8000007f, 0x555555a9ffffffad,
  0x8000003e0000007e, 0x555555a955555503,
  0x8000003d8000007d, 0x5555556b55555541,
  0x8000000f00000020, 0x55555557ffffffff,
  0x8000000080000003, 0x5555555755555555,
  0x8000000000000002, 0x55555556aaaaaaab,
  0x55555556aaaaaaaa, 0x0000000000000001,
  0x0000000000000000, 0xffffffff33333335,
  0xffffffff55555556, 0xfffffffe66666669,
  0xfffffffeaaaaaaac, 0xffffffe666666681,
  0xffffffeaaaaaaac0, 0xffffff9c00000065,
  0xffffffacaaaaaafe, 0xffffff9b33333399,
  0xffffffac00000054, 0xffffff9a666666cd,
  0xffffffab555555aa, 0xffff999c00006665,
  0xffffaaacaaaafffe, 0xffff999b33339999,
  0xffffaaac00005554, 0xffff999a6666cccd,
  0xffffaaab5555aaaa, 0xd70a3d70f5c28f5d,
  0xddddddde22222222, 0xbbbbbbbc44444445,
  0xc71c71c78e38e38e, 0x9999999c66666665,
  0xaaaaaaacfffffffe, 0x9999999b99999999,
  0xaaaaaaac55555554, 0x9999999acccccccd,
  0xaaaaaaabaaaaaaaa, 0x9999999a00000001,
  0xaaaaaaab00000000, 0x9999999933333335,
  0xaaaaaaaa55555556, 0x7777777888888889,
  0x8e38e38f1c71c71c, 0x5c28f5c3d70a3d71,
  0x7777777888888888, 0x3333999a66660001,
  0x5555aaab55550000, 0x3333999999993335,
  0x5555aaaaaaaa5556, 0x33339998cccc6669,
  0x5555aaa9ffffaaac, 0x33339997ffff999d,
  0x5555aaa955550002, 0x3333339a66666601,
  0x555555ab55555500, 0x3333339999999935,
  0x555555aaaaaaaa56, 0x33333398cccccc69,
  0x555555a9ffffffac, 0x33333397ffffff9d,
  0x555555a955555502, 0x3333334d99999981,
  0x5555556b55555540, 0x3333333666666665,
  0x55555557fffffffe, 0x3333333599999999,
  0x5555555755555554, 0x33333334cccccccd,
  0x33333334cccccccc, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00008001,
  0xffffffff33333334, 0xfffffffe00010001,
  0xfffffffe66666668, 0xffffffe000100001,
  0xffffffe666666680, 0xffffff83003e8001,
  0xffffff9c00000064, 0xffffff82003f0001,
  0xffffff9b33333398, 0xffffff81003f8001,
  0xffffff9a666666cc, 0xffff80033ffe8001,
  0xffff999c00006664, 0xffff80023fff0001,
  0xffff999b33339998, 0xffff80013fff8001,
  0xffff999a6666cccc, 0xcccce66699998001,
  0xd70a3d70f5c28f5c, 0xaaaad555aaaa8001,
  0xbbbbbbbc44444444, 0x80004002fffe8001,
  0x9999999c66666664, 0x80004001ffff0001,
  0x9999999b99999998, 0x80004000ffff8001,
  0x9999999acccccccc, 0x8000400000000001,
  0x9999999a00000000, 0x80003fff00008001,
  0x9999999933333334, 0x5555aaab55550001,
  0x7777777888888888, 0x3333999a66660001,
  0x5c28f5c3d70a3d70, 0x0000ffffc0000001,
  0x3333999a66660000, 0x0000fffec0008001,
  0x3333999999993334, 0x0000fffdc0010001,
  0x33339998cccc6668, 0x0000fffcc0018001,
  0x33339997ffff999c, 0x0000807fffc00001,
  0x3333339a66666600, 0x0000807effc08001,
  0x3333339999999934, 0x0000807dffc10001,
  0x33333398cccccc68, 0x0000807cffc18001,
  0x33333397ffffff9c, 0x0000801ffff00001,
  0x3333334d99999980, 0x00008002fffe8001,
  0x3333333666666664, 0x00008001ffff0001,
  0x3333333599999998, 0x00008000ffff8001,
  0x00008000ffff8000, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00008000,
  0xffffffff00008000, 0xfffffffe0000ffff,
  0xfffffffe00010000, 0xffffffe0000fffe1,
  0xffffffe000100000, 0xffffff83003e7f84,
  0xffffff83003e8000, 0xffffff82003eff83,
  0xffffff82003f0000, 0xffffff81003f7f82,
  0xffffff81003f8000, 0xffff80033ffe0004,
  0xffff80033ffe8000, 0xffff80023ffe8003,
  0xffff80023fff0000, 0xffff80013fff0002,
  0xffff80013fff8000, 0xcccce66666664cce,
  0xcccce66699998000, 0xaaaad55555552aac,
  0xaaaad555aaaa8000, 0x800040027ffe8004,
  0x80004002fffe8000, 0x800040017fff0003,
  0x80004001ffff0000, 0x800040007fff8002,
  0x80004000ffff8000, 0x80003fff80000001,
  0x8000400000000000, 0x80003ffe80008000,
  0x80003fff00008000, 0x5555aaaaaaaa5557,
  0x5555aaab55550000, 0x3333999999993335,
  0x3333999a66660000, 0x0000fffec0008001,
  0x0000ffffc0000000, 0x0000fffdc0010000,
  0x0000fffec0008000, 0x0000fffcc0017fff,
  0x0000fffdc0010000, 0x0000fffbc001fffe,
  0x0000fffcc0018000, 0x0000807effc00081,
  0x0000807fffc00000, 0x0000807dffc08080,
  0x0000807effc08000, 0x0000807cffc1007f,
  0x0000807dffc10000, 0x0000807bffc1807e,
  0x0000807cffc18000, 0x0000801efff00021,
  0x0000801ffff00000, 0x00008001fffe8004,
  0x00008002fffe8000, 0x00008000ffff0003,
  0x00008001ffff0000, 0x00007fffffff8002,
  0x00007fffffff8001, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00007fff,
  0xffffffff00007fff, 0xfffffffe0000fffd,
  0xfffffffe0000fffe, 0xffffffe0000fffc1,
  0xffffffe0000fffe0, 0xffffff83003e7f07,
  0xffffff83003e7f83, 0xffffff82003eff05,
  0xffffff82003eff82, 0xffffff81003f7f03,
  0xffffff81003f7f81, 0xffff80033ffd8007,
  0xffff80033ffe0003, 0xffff80023ffe0005,
  0xffff80023ffe8002, 0xffff80013ffe8003,
  0xffff80013fff0001, 0xcccce6663333199b,
  0xcccce66666664ccd, 0xaaaad554ffffd557,
  0xaaaad55555552aab, 0x80004001fffe8007,
  0x800040027ffe8003, 0x80004000ffff0005,
  0x800040017fff0002, 0x80003fffffff8003,
  0x800040007fff8001, 0x80003fff00000001,
  0x80003fff80000000, 0x80003ffe00007fff,
  0x80003ffe80007fff, 0x5555aaa9ffffaaad,
  0x5555aaaaaaaa5556, 0x33339998cccc6669,
  0x3333999999993334, 0x0000fffdc0010001,
  0x0000fffec0008000, 0x0000fffcc0017fff,
  0x0000fffdc000ffff, 0x0000fffbc001fffd,
  0x0000fffcc0017ffe, 0x0000fffac0027ffb,
  0x0000fffbc001fffd, 0x0000807dffc00101,
  0x0000807effc00080, 0x0000807cffc080ff,
  0x0000807dffc0807f, 0x0000807bffc100fd,
  0x0000807cffc1007e, 0x0000807affc180fb,
  0x0000807bffc1807d, 0x0000801dfff00041,
  0x0000801efff00020, 0x00008000fffe8007,
  0x00008001fffe8003, 0x00007fffffff0005,
  0x00008000ffff0002, 0x00007ffeffff8003,
  0x00007ffeffff8002, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00007ffe,
  0xffffffff00007ffe, 0xfffffffe0000fffb,
  0xfffffffe0000fffc, 0xffffffe0000fffa1,
  0xffffffe0000fffc0, 0xffffff83003e7e8a,
  0xffffff83003e7f06, 0xffffff82003efe87,
  0xffffff82003eff04, 0xffffff81003f7e84,
  0xffffff81003f7f02, 0xffff80033ffd000a,
  0xffff80033ffd8006, 0xffff80023ffd8007,
  0xffff80023ffe0004, 0xffff80013ffe0004,
  0xffff80013ffe8002, 0xcccce665ffffe668,
  0xcccce6663333199a, 0xaaaad554aaaa8002,
  0xaaaad554ffffd556, 0x800040017ffe800a,
  0x80004001fffe8006, 0x800040007fff0007,
  0x80004000ffff0004, 0x80003fff7fff8004,
  0x80003fffffff8002, 0x80003ffe80000001,
  0x80003fff00000000, 0x80003ffd80007ffe,
  0x80003ffe00007ffe, 0x5555aaa955550003,
  0x5555aaa9ffffaaac, 0x33339997ffff999d,
  0x33339998cccc6668, 0x0000fffcc0018001,
  0x0000fffdc0010000, 0x0000fffbc001fffe,
  0x0000fffcc0017ffe, 0x0000fffac0027ffb,
  0x0000fffbc001fffc, 0x0000fff9c002fff8,
  0x0000fffac0027ffa, 0x0000807cffc00181,
  0x0000807dffc00100, 0x0000807bffc0817e,
  0x0000807cffc080fe, 0x0000807affc1017b,
  0x0000807bffc100fc, 0x00008079ffc18178,
  0x0000807affc180fa, 0x0000801cfff00061,
  0x0000801dfff00040, 0x00007ffffffe800a,
  0x00008000fffe8006, 0x00007ffeffff0007,
  0x00007fffffff0004, 0x00007ffdffff8004,
  0x00007ffdffff8003, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000081,
  0xffffffff00007ffd, 0xfffffffe00000101,
  0xfffffffe0000fffa, 0xffffffe000001001,
  0xffffffe0000fffa0, 0xffffff8300003e81,
  0xffffff83003e7e89, 0xffffff8200003f01,
  0xffffff82003efe86, 0xffffff8100003f81,
  0xffffff81003f7e83, 0xffff8003003ffe81,
  0xffff80033ffd0009, 0xffff8002003fff01,
  0xffff80023ffd8006, 0xffff8001003fff81,
  0xffff80013ffe0003, 0xcccccce699999981,
  0xcccce665ffffe667, 0xaaaaaad5aaaaaa81,
  0xaaaad554aaaa8001, 0x80000042fffffe81,
  0x800040017ffe8009, 0x80000041ffffff01,
  0x800040007fff0006, 0x80000040ffffff81,
  0x80003fff7fff8003, 0x8000004000000001,
  0x80003ffe80000000, 0x8000003f00000081,
  0x80003ffd80007ffd, 0x555555ab55555501,
  0x5555aaa955550002, 0x3333339a66666601,
  0x33339997ffff999c, 0x0000807fffc00001,
  0x0000fffcc0018000, 0x0000807effc00081,
  0x0000fffbc001fffd, 0x0000807dffc00101,
  0x0000fffac0027ffa, 0x0000807cffc00181,
  0x0000fff9c002fff7, 0x000000ffffffc001,
  0x0000807cffc00180, 0x000000feffffc081,
  0x0000807bffc0817d, 0x000000fdffffc101,
  0x0000807affc1017a, 0x000000fcffffc181,
  0x00008079ffc18177, 0x0000009ffffff001,
  0x0000801cfff00060, 0x00000082fffffe81,
  0x00007ffffffe8009, 0x00000081ffffff01,
  0x00007ffeffff0006, 0x00000080ffffff81,
  0x00000080ffffff80, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000080,
  0xffffffff00000080, 0xfffffffe000000ff,
  0xfffffffe00000100, 0xffffffe000000fe1,
  0xffffffe000001000, 0xffffff8300003e04,
  0xffffff8300003e80, 0xffffff8200003e83,
  0xffffff8200003f00, 0xffffff8100003f02,
  0xffffff8100003f80, 0xffff8003003f7e84,
  0xffff8003003ffe80, 0xffff8002003f7f03,
  0xffff8002003fff00, 0xffff8001003f7f82,
  0xffff8001003fff80, 0xcccccce66666664e,
  0xcccccce699999980, 0xaaaaaad55555552c,
  0xaaaaaad5aaaaaa80, 0x800000427ffffe84,
  0x80000042fffffe80, 0x800000417fffff03,
  0x80000041ffffff00, 0x800000407fffff82,
  0x80000040ffffff80, 0x8000003f80000001,
  0x8000004000000000, 0x8000003e80000080,
  0x8000003f00000080, 0x555555aaaaaaaa57,
  0x555555ab55555500, 0x3333339999999935,
  0x3333339a66666600, 0x0000807effc08001,
  0x0000807fffc00000, 0x0000807dffc08080,
  0x0000807effc00080, 0x0000807cffc080ff,
  0x0000807dffc00100, 0x0000807bffc0817e,
  0x0000807cffc00180, 0x000000feffffc081,
  0x000000ffffffc000, 0x000000fdffffc100,
  0x000000feffffc080, 0x000000fcffffc17f,
  0x000000fdffffc100, 0x000000fbffffc1fe,
  0x000000fcffffc180, 0x0000009efffff021,
  0x0000009ffffff000, 0x00000081fffffe84,
  0x00000082fffffe80, 0x00000080ffffff03,
  0x00000081ffffff00, 0x0000007fffffff82,
  0x0000007fffffff81, 0x0000000000000001,
  0x0000000000000000, 0xffffffff0000007f,
  0xffffffff0000007f, 0xfffffffe000000fd,
  0xfffffffe000000fe, 0xffffffe000000fc1,
  0xffffffe000000fe0, 0xffffff8300003d87,
  0xffffff8300003e03, 0xffffff8200003e05,
  0xffffff8200003e82, 0xffffff8100003e83,
  0xffffff8100003f01, 0xffff8003003efe87,
  0xffff8003003f7e83, 0xffff8002003eff05,
  0xffff8002003f7f02, 0xffff8001003eff83,
  0xffff8001003f7f81, 0xcccccce63333331b,
  0xcccccce66666664d, 0xaaaaaad4ffffffd7,
  0xaaaaaad55555552b, 0x80000041fffffe87,
  0x800000427ffffe83, 0x80000040ffffff05,
  0x800000417fffff02, 0x8000003fffffff83,
  0x800000407fffff81, 0x8000003f00000001,
  0x8000003f80000000, 0x8000003e0000007f,
  0x8000003e8000007f, 0x555555a9ffffffad,
  0x555555aaaaaaaa56, 0x33333398cccccc69,
  0x3333339999999934, 0x0000807dffc10001,
  0x0000807effc08000, 0x0000807cffc1007f,
  0x0000807dffc0807f, 0x0000807bffc100fd,
  0x0000807cffc080fe, 0x0000807affc1017b,
  0x0000807bffc0817d, 0x000000fdffffc101,
  0x000000feffffc080, 0x000000fcffffc17f,
  0x000000fdffffc0ff, 0x000000fbffffc1fd,
  0x000000fcffffc17e, 0x000000faffffc27b,
  0x000000fbffffc1fd, 0x0000009dfffff041,
  0x0000009efffff020, 0x00000080fffffe87,
  0x00000081fffffe83, 0x0000007fffffff05,
  0x00000080ffffff02, 0x0000007effffff83,
  0x0000007effffff82, 0x0000000000000001,
  0x0000000000000000, 0xffffffff0000007e,
  0xffffffff0000007e, 0xfffffffe000000fb,
  0xfffffffe000000fc, 0xffffffe000000fa1,
  0xffffffe000000fc0, 0xffffff8300003d0a,
  0xffffff8300003d86, 0xffffff8200003d87,
  0xffffff8200003e04, 0xffffff8100003e04,
  0xffffff8100003e82, 0xffff8003003e7e8a,
  0xffff8003003efe86, 0xffff8002003e7f07,
  0xffff8002003eff04, 0xffff8001003e7f84,
  0xffff8001003eff82, 0xcccccce5ffffffe8,
  0xcccccce63333331a, 0xaaaaaad4aaaaaa82,
  0xaaaaaad4ffffffd6, 0x800000417ffffe8a,
  0x80000041fffffe86, 0x800000407fffff07,
  0x80000040ffffff04, 0x8000003f7fffff84,
  0x8000003fffffff82, 0x8000003e80000001,
  0x8000003f00000000, 0x8000003d8000007e,
  0x8000003e0000007e, 0x555555a955555503,
  0x555555a9ffffffac, 0x33333397ffffff9d,
  0x33333398cccccc68, 0x0000807cffc18001,
  0x0000807dffc10000, 0x0000807bffc1807e,
  0x0000807cffc1007e, 0x0000807affc180fb,
  0x0000807bffc100fc, 0x00008079ffc18178,
  0x0000807affc1017a, 0x000000fcffffc181,
  0x000000fdffffc100, 0x000000fbffffc1fe,
  0x000000fcffffc17e, 0x000000faffffc27b,
  0x000000fbffffc1fc, 0x000000f9ffffc2f8,
  0x000000faffffc27a, 0x0000009cfffff061,
  0x0000009dfffff040, 0x0000007ffffffe8a,
  0x00000080fffffe86, 0x0000007effffff07,
  0x0000007fffffff04, 0x0000007dffffff84,
  0x0000007dffffff83, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000021,
  0xffffffff0000007d, 0xfffffffe00000041,
  0xfffffffe000000fa, 0xffffffe000000401,
  0xffffffe000000fa0, 0xffffff8300000fa1,
  0xffffff8300003d09, 0xffffff8200000fc1,
  0xffffff8200003d86, 0xffffff8100000fe1,
  0xffffff8100003e03, 0xffff8003000fffa1,
  0xffff8003003e7e89, 0xffff8002000fffc1,
  0xffff8002003e7f06, 0xffff8001000fffe1,
  0xffff8001003e7f83, 0xccccccd366666661,
  0xcccccce5ffffffe7, 0xaaaaaab5aaaaaaa1,
  0xaaaaaad4aaaaaa81, 0x80000012ffffffa1,
  0x800000417ffffe89, 0x80000011ffffffc1,
  0x800000407fffff06, 0x80000010ffffffe1,
  0x8000003f7fffff83, 0x8000001000000001,
  0x8000003e80000000, 0x8000000f00000021,
  0x8000003d8000007d, 0x5555556b55555541,
  0x555555a955555502, 0x3333334d99999981,
  0x33333397ffffff9c, 0x0000801ffff00001,
  0x0000807cffc18000, 0x0000801efff00021,
  0x0000807bffc1807d, 0x0000801dfff00041,
  0x0000807affc180fa, 0x0000801cfff00061,
  0x00008079ffc18177, 0x0000009ffffff001,
  0x000000fcffffc180, 0x0000009efffff021,
  0x000000fbffffc1fd, 0x0000009dfffff041,
  0x000000faffffc27a, 0x0000009cfffff061,
  0x000000f9ffffc2f7, 0x0000003ffffffc01,
  0x0000009cfffff060, 0x00000022ffffffa1,
  0x0000007ffffffe89, 0x00000021ffffffc1,
  0x0000007effffff06, 0x00000020ffffffe1,
  0x00000020ffffffe0, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000004,
  0xffffffff00000020, 0xfffffffe00000007,
  0xfffffffe00000040, 0xffffffe000000061,
  0xffffffe000000400, 0xffffff8300000178,
  0xffffff8300000fa0, 0xffffff820000017b,
  0xffffff8200000fc0, 0xffffff810000017e,
  0xffffff8100000fe0, 0xffff800300017ff8,
  0xffff8003000fffa0, 0xffff800200017ffb,
  0xffff8002000fffc0, 0xffff800100017ffe,
  0xffff8001000fffe0, 0xcccccccd9999999a,
  0xccccccd366666660, 0xaaaaaaac00000000,
  0xaaaaaab5aaaaaaa0, 0x800000047ffffff8,
  0x80000012ffffffa0, 0x800000037ffffffb,
  0x80000011ffffffc0, 0x800000027ffffffe,
  0x80000010ffffffe0, 0x8000000180000001,
  0x8000001000000000, 0x8000000080000004,
  0x8000000f00000020, 0x55555557ffffffff,
  0x5555556b55555540, 0x3333333666666665,
  0x3333334d99999980, 0x00008002fffe8001,
  0x0000801ffff00000, 0x00008001fffe8004,
  0x0000801efff00020, 0x00008000fffe8007,
  0x0000801dfff00040, 0x00007ffffffe800a,
  0x0000801cfff00060, 0x00000082fffffe81,
  0x0000009ffffff000, 0x00000081fffffe84,
  0x0000009efffff020, 0x00000080fffffe87,
  0x0000009dfffff040, 0x0000007ffffffe8a,
  0x0000009cfffff060, 0x00000022ffffffa1,
  0x0000003ffffffc00, 0x00000005fffffff8,
  0x00000022ffffffa0, 0x00000004fffffffb,
  0x00000021ffffffc0, 0x00000003fffffffe,
  0x00000003fffffffd, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000003,
  0xffffffff00000003, 0xfffffffe00000005,
  0xfffffffe00000006, 0xffffffe000000041,
  0xffffffe000000060, 0xffffff83000000fb,
  0xffffff8300000177, 0xffffff82000000fd,
  0xffffff820000017a, 0xffffff81000000ff,
  0xffffff810000017d, 0xffff80030000fffb,
  0xffff800300017ff7, 0xffff80020000fffd,
  0xffff800200017ffa, 0xffff80010000ffff,
  0xffff800100017ffd, 0xcccccccd66666667,
  0xcccccccd99999999, 0xaaaaaaabaaaaaaab,
  0xaaaaaaabffffffff, 0x80000003fffffffb,
  0x800000047ffffff7, 0x80000002fffffffd,
  0x800000037ffffffa, 0x80000001ffffffff,
  0x800000027ffffffd, 0x8000000100000001,
  0x8000000180000000, 0x8000000000000003,
  0x8000000080000003, 0x5555555755555555,
  0x55555557fffffffe, 0x3333333599999999,
  0x3333333666666664, 0x00008001ffff0001,
  0x00008002fffe8000, 0x00008000ffff0003,
  0x00008001fffe8003, 0x00007fffffff0005,
  0x00008000fffe8006, 0x00007ffeffff0007,
  0x00007ffffffe8009, 0x00000081ffffff01,
  0x00000082fffffe80, 0x00000080ffffff03,
  0x00000081fffffe83, 0x0000007fffffff05,
  0x00000080fffffe86, 0x0000007effffff07,
  0x0000007ffffffe89, 0x00000021ffffffc1,
  0x00000022ffffffa0, 0x00000004fffffffb,
  0x00000005fffffff7, 0x00000003fffffffd,
  0x00000004fffffffa, 0x00000002ffffffff,
  0x00000002fffffffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000002,
  0xffffffff00000002, 0xfffffffe00000003,
  0xfffffffe00000004, 0xffffffe000000021,
  0xffffffe000000040, 0xffffff830000007e,
  0xffffff83000000fa, 0xffffff820000007f,
  0xffffff82000000fc, 0xffffff8100000080,
  0xffffff81000000fe, 0xffff800300007ffe,
  0xffff80030000fffa, 0xffff800200007fff,
  0xffff80020000fffc, 0xffff800100008000,
  0xffff80010000fffe, 0xcccccccd33333334,
  0xcccccccd66666666, 0xaaaaaaab55555556,
  0xaaaaaaabaaaaaaaa, 0x800000037ffffffe,
  0x80000003fffffffa, 0x800000027fffffff,
  0x80000002fffffffc, 0x8000000180000000,
  0x80000001fffffffe, 0x8000000080000001,
  0x8000000100000000, 0x7fffffff80000002,
  0x8000000000000002, 0x55555556aaaaaaab,
  0x5555555755555554, 0x33333334cccccccd,
  0x3333333599999998, 0x00008000ffff8001,
  0x00008001ffff0000, 0x00007fffffff8002,
  0x00008000ffff0002, 0x00007ffeffff8003,
  0x00007fffffff0004, 0x00007ffdffff8004,
  0x00007ffeffff0006, 0x00000080ffffff81,
  0x00000081ffffff00, 0x0000007fffffff82,
  0x00000080ffffff02, 0x0000007effffff83,
  0x0000007fffffff04, 0x0000007dffffff84,
  0x0000007effffff06, 0x00000020ffffffe1,
  0x00000021ffffffc0, 0x00000003fffffffe,
  0x00000004fffffffa, 0x00000002ffffffff,
  0x00000003fffffffc, 0x0000000200000000,
};
const unsigned kExpectedCount_NEON_umlsl2_2D = 961;

#endif  // VIXL_SIM_UMLSL2_2D_TRACE_AARCH64_H_
