/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.image.NIOBufferImage;
import org.web3d.util.PropertyTools;
import org.web3d.util.TextureCache;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.MaterialColorListener;
import org.web3d.vrml.nodes.VRMLAppearanceChildNodeType;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLMultiTextureNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.shape.TextureStage;

public abstract class BaseAppearance
extends AbstractNode
implements VRMLAppearanceNodeType,
VRMLTextureListener {
    protected static final int FIELD_MATERIAL = 1;
    protected static final int FIELD_TEXTURE = 2;
    protected static final int FIELD_TEXTURE_TRANSFORM = 3;
    protected static final int FIELD_LINE_PROPERTIES = 4;
    protected static final int FIELD_FILL_PROPERTIES = 5;
    protected static final int FIELD_TEXTURE_PROPERTIES = 6;
    protected static final boolean DEFAULT_USETEXTURECACHE = true;
    protected static final String USETEXTURECACHE_PROP = "org.web3d.vrml.renderer.common.nodes.shape.useTextureCache";
    protected static final boolean useTextureCache;
    protected static final boolean DEFAULT_USE_MIPMAPS = false;
    protected static final String USE_MIPMAPS_PROP = "org.web3d.vrml.renderer.common.nodes.shape.useMipMaps";
    protected static boolean useMipMaps;
    protected static final int DEFAULT_ANISOTROPIC_DEGREE = 1;
    protected static final String ANISOTROPIC_DEGREE_PROP = "org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree";
    protected static final int anisotropicDegree;
    private static final int NUM_FIELDS = 7;
    protected static final String MATERIAL_PROTO_MSG = "Proto does not describe a Material object";
    protected static final String MATERIAL_NODE_MSG = "Node does not describe a Material object";
    protected static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture object";
    protected static final String TEXTURE_NODE_MSG = "Node does not describe a Texture object";
    protected static final String TRANSFORM_PROTO_MSG = "Proto does not describe a TextureTransform object";
    protected static final String TRANSFORM_NODE_MSG = "Node does not describe a TextureTransform object";
    protected static final String FILL_PROP_PROTO_MSG = "Proto does not describe a FillProperties object";
    protected static final String FILL_PROP_NODE_MSG = "Node does not describe a FillProperties object";
    protected static final String LINE_PROP_PROTO_MSG = "Proto does not describe a LineProperties object";
    protected static final String LINE_PROP_NODE_MSG = "Node does not describe a LineProperties object";
    protected static final String TEXTURE_PROP_NODE_MSG = "Node does not describe a TextureProperties object";
    protected static final String TEXTURE_PROP_PROTO_MSG = "Proto does not describe a TextureProperties object";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected VRMLProtoInstance pMaterial;
    protected VRMLMaterialNodeType vfMaterial;
    protected VRMLProtoInstance pTexture;
    protected VRMLTextureNodeType vfTexture;
    protected VRMLProtoInstance pTextureTransform;
    protected VRMLTextureTransformNodeType vfTextureTransform;
    protected VRMLProtoInstance pFillProperties;
    protected VRMLAppearanceChildNodeType vfFillProperties;
    protected VRMLProtoInstance pLineProperties;
    protected VRMLAppearanceChildNodeType vfLineProperties;
    protected VRMLProtoInstance pTextureProperties;
    protected VRMLTextureProperties2DNodeType vfTextureProperties;
    private ArrayList colorListeners;
    protected TextureCache cache;
    protected int numStages = 0;
    protected TextureStage[] stages = new TextureStage[0];
    protected String[] urls = new String[0];
    protected static float totalTextureSize;

    protected BaseAppearance() {
        super("Appearance");
        totalTextureSize = 0.0f;
        this.hasChanged = new boolean[7];
    }

    protected BaseAppearance(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        super.notifyExternProtoLoaded(n, vRMLNodeType);
        int[] nArray = vRMLNodeType.getSecondaryType();
        boolean bl = false;
        switch (n) {
            case 1: {
                BaseAppearance.checkSecondaryType(vRMLNodeType, 29, MATERIAL_PROTO_MSG);
                this.pMaterial = (VRMLProtoInstance)vRMLNodeType;
                this.vfMaterial = (VRMLMaterialNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                if (this.vfMaterial == null || this.colorListeners == null) break;
                for (int i = 0; i < this.colorListeners.size(); ++i) {
                    MaterialColorListener materialColorListener = (MaterialColorListener)this.colorListeners.get(i);
                    this.vfMaterial.addMaterialColorListener(materialColorListener);
                }
                break;
            }
            case 4: {
                BaseAppearance.checkSecondaryType(vRMLNodeType, 1, LINE_PROP_PROTO_MSG);
                this.pLineProperties = (VRMLProtoInstance)vRMLNodeType;
                this.vfLineProperties = (VRMLAppearanceChildNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                break;
            }
            case 5: {
                BaseAppearance.checkSecondaryType(vRMLNodeType, 1, FILL_PROP_PROTO_MSG);
                this.pFillProperties = (VRMLProtoInstance)vRMLNodeType;
                this.vfFillProperties = (VRMLAppearanceChildNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                break;
            }
            case 2: {
                BaseAppearance.checkSecondaryType(vRMLNodeType, 50, TEXTURE_PROTO_MSG);
                this.pTexture = (VRMLProtoInstance)vRMLNodeType;
                this.vfTexture = (VRMLTextureNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                break;
            }
            case 3: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != 51) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new InvalidFieldValueException(TRANSFORM_PROTO_MSG);
                }
                this.pTextureTransform = (VRMLProtoInstance)vRMLNodeType;
                this.vfTextureTransform = (VRMLTextureTransformNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                break;
            }
            default: {
                System.out.println("BaseAppearance: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    protected void setTextureCache(TextureCache textureCache) {
        this.cache = textureCache;
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, NIOBufferImage nIOBufferImage, String string) {
        this.insureStageSize(n + 1, true);
        int n2 = this.vfTexture.getTextureType();
        switch (n2) {
            case 0: 
            case 2: {
                this.stages[n].images = this.processImage(n, nIOBufferImage, string);
                this.urls[n] = string;
                break;
            }
            case 1: {
                NIOBufferImage[] nIOBufferImageArray;
                int n3 = 0;
                if (this.stages[n3].images.length < n + 1) {
                    this.stages[n3].images = new NIOBufferImage[n + 1];
                }
                if ((nIOBufferImageArray = this.processImage(n, nIOBufferImage, string)) != null && nIOBufferImageArray.length != 0) {
                    this.stages[n3].images[n] = nIOBufferImageArray[0];
                }
                this.urls[n3] = null;
            }
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, NIOBufferImage[] nIOBufferImageArray, String[] stringArray) {
        this.insureStageSize(n, true);
        for (int i = 0; i < n; ++i) {
            this.stages[i].images = this.processImage(i, nIOBufferImageArray[i], stringArray[i]);
            this.urls[i] = stringArray[i];
        }
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
        this.insureStageSize(n + 1, false);
        this.stages[n].mode = n2;
        this.stages[n].source = n3;
        this.stages[n].function = n4;
        this.stages[n].alpha = f;
        this.stages[n].color[0] = fArray[0];
        this.stages[n].color[1] = fArray[1];
        this.stages[n].color[2] = fArray[2];
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
        this.insureStageSize(n, false);
        for (int i = 0; i < n; ++i) {
            this.stages[i].mode = nArray[i];
            this.stages[i].source = nArray2[i];
            this.stages[i].function = nArray3[i];
            this.stages[i].alpha = f;
            this.stages[i].color[0] = fArray[0];
            this.stages[i].color[1] = fArray[1];
            this.stages[i].color[2] = fArray[2];
        }
    }

    public void setMaterial(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        MaterialColorListener materialColorListener;
        int n;
        VRMLMaterialNodeType vRMLMaterialNodeType;
        VRMLNodeType vRMLNodeType2 = this.pMaterial != null ? this.pMaterial : this.vfMaterial;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLMaterialNodeType = (VRMLMaterialNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pMaterial = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLMaterialNodeType != null && !(vRMLMaterialNodeType instanceof VRMLMaterialNodeType)) {
                throw new InvalidFieldValueException(MATERIAL_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLMaterialNodeType)) {
                throw new InvalidFieldValueException(MATERIAL_NODE_MSG);
            }
            this.pMaterial = null;
            vRMLMaterialNodeType = (VRMLMaterialNodeType)vRMLNodeType;
        }
        this.vfMaterial = vRMLMaterialNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
                if (this.colorListeners != null) {
                    for (n = 0; n < this.colorListeners.size(); ++n) {
                        materialColorListener = (MaterialColorListener)this.colorListeners.get(n);
                        this.vfMaterial.removeMaterialColorListener(materialColorListener);
                    }
                }
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
        if (this.vfMaterial != null && this.colorListeners != null) {
            for (n = 0; n < this.colorListeners.size(); ++n) {
                materialColorListener = (MaterialColorListener)this.colorListeners.get(n);
                this.vfMaterial.addMaterialColorListener(materialColorListener);
            }
        }
    }

    public VRMLNodeType getMaterial() {
        if (this.pMaterial != null) {
            return this.pMaterial;
        }
        return this.vfMaterial;
    }

    public void setTexture(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureNodeType vRMLTextureNodeType;
        VRMLNodeType vRMLNodeType2 = this.pTexture != null ? this.pTexture : this.vfTexture;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLTextureNodeType = (VRMLTextureNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pTexture = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLTextureNodeType != null && !(vRMLTextureNodeType instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
            }
            this.pTexture = null;
            vRMLTextureNodeType = (VRMLTextureNodeType)vRMLNodeType;
        }
        this.vfTexture = vRMLTextureNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (this.vfTexture != null) {
                switch (this.vfTexture.getTextureType()) {
                    case 0: {
                        NIOBufferImage nIOBufferImage = ((VRMLTexture2DNodeType)this.vfTexture).getImage();
                        if (nIOBufferImage == null) break;
                        this.insureStageSize(1, true);
                        this.stages[0].images = this.processImage(0, nIOBufferImage, null);
                        this.urls[0] = null;
                    }
                }
            }
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public VRMLNodeType getTexture() {
        if (this.pTexture != null) {
            return this.pTexture;
        }
        return this.vfTexture;
    }

    public void setTextureTransform(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureTransformNodeType vRMLTextureTransformNodeType;
        VRMLNodeType vRMLNodeType2 = this.pTextureTransform != null ? this.pTextureTransform : this.vfTextureTransform;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLTextureTransformNodeType = (VRMLTextureTransformNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pTextureTransform = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLTextureTransformNodeType != null && !(vRMLTextureTransformNodeType instanceof VRMLTextureTransformNodeType)) {
                throw new InvalidFieldValueException(TRANSFORM_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureTransformNodeType)) {
                throw new InvalidFieldValueException(TRANSFORM_NODE_MSG);
            }
            this.pTextureTransform = null;
            vRMLTextureTransformNodeType = (VRMLTextureTransformNodeType)vRMLNodeType;
        }
        this.vfTextureTransform = vRMLTextureTransformNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public VRMLNodeType getTextureTransform() {
        if (this.pTextureTransform != null) {
            return this.pTextureTransform;
        }
        return this.vfTextureTransform;
    }

    public void setLineProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLAppearanceChildNodeType vRMLAppearanceChildNodeType;
        VRMLNodeType vRMLNodeType2 = this.pLineProperties != null ? this.pLineProperties : this.vfLineProperties;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLAppearanceChildNodeType = (VRMLAppearanceChildNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pLineProperties = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLAppearanceChildNodeType != null && !(vRMLAppearanceChildNodeType instanceof VRMLAppearanceChildNodeType)) {
                throw new InvalidFieldValueException(LINE_PROP_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLAppearanceChildNodeType)) {
                throw new InvalidFieldValueException(LINE_PROP_NODE_MSG);
            }
            this.pLineProperties = null;
            vRMLAppearanceChildNodeType = (VRMLAppearanceChildNodeType)vRMLNodeType;
        }
        this.vfLineProperties = vRMLAppearanceChildNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public VRMLNodeType getLineProperties() {
        if (this.pLineProperties != null) {
            return this.pLineProperties;
        }
        return this.vfLineProperties;
    }

    public void setTextureProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLAppearanceChildNodeType vRMLAppearanceChildNodeType;
        VRMLNodeType vRMLNodeType2 = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLAppearanceChildNodeType = (VRMLAppearanceChildNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pTextureProperties = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLAppearanceChildNodeType != null && !(vRMLAppearanceChildNodeType instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROP_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROP_NODE_MSG);
            }
            this.pTextureProperties = null;
            vRMLAppearanceChildNodeType = (VRMLTextureProperties2DNodeType)vRMLNodeType;
        }
        this.vfTextureProperties = (VRMLTextureProperties2DNodeType)vRMLAppearanceChildNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public VRMLNodeType getTextureProperties() {
        if (this.pTextureProperties != null) {
            return this.pTextureProperties;
        }
        return this.vfTextureProperties;
    }

    public void setFillProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLAppearanceChildNodeType vRMLAppearanceChildNodeType;
        VRMLNodeType vRMLNodeType2 = this.pFillProperties != null ? this.pFillProperties : this.vfFillProperties;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLAppearanceChildNodeType = (VRMLAppearanceChildNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pFillProperties = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLAppearanceChildNodeType != null && !(vRMLAppearanceChildNodeType instanceof VRMLAppearanceChildNodeType)) {
                throw new InvalidFieldValueException(FILL_PROP_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLAppearanceChildNodeType)) {
                throw new InvalidFieldValueException(FILL_PROP_NODE_MSG);
            }
            this.pFillProperties = null;
            vRMLAppearanceChildNodeType = (VRMLAppearanceChildNodeType)vRMLNodeType;
        }
        this.vfFillProperties = vRMLAppearanceChildNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public VRMLNodeType getFillProperties() {
        if (this.pFillProperties != null) {
            return this.pFillProperties;
        }
        return this.vfFillProperties;
    }

    public void setSolid(boolean bl) {
    }

    public void setLightingEnabled(boolean bl) {
    }

    public void setCCW(boolean bl) {
    }

    public void setLocalColor(boolean bl, boolean bl2) {
    }

    public void addMaterialColorListener(MaterialColorListener materialColorListener) {
        if (this.vfMaterial != null) {
            this.vfMaterial.addMaterialColorListener(materialColorListener);
        }
        if (this.colorListeners == null) {
            this.colorListeners = new ArrayList();
        }
        if (!this.colorListeners.contains(materialColorListener)) {
            this.colorListeners.add(materialColorListener);
        }
    }

    public void removeMaterialColorListener(MaterialColorListener materialColorListener) {
        if (this.vfMaterial != null) {
            this.vfMaterial.removeMaterialColorListener(materialColorListener);
        }
        this.colorListeners.remove(materialColorListener);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pMaterial != null) {
            this.pMaterial.setupFinished();
        } else if (this.vfMaterial != null) {
            this.vfMaterial.setupFinished();
        }
        if (this.pTexture != null) {
            this.pTexture.setupFinished();
        } else if (this.vfTexture != null) {
            this.vfTexture.setupFinished();
        }
        if (this.pTextureTransform != null) {
            this.pTextureTransform.setupFinished();
        } else if (this.vfTextureTransform != null) {
            this.vfTextureTransform.setupFinished();
        }
        if (this.pLineProperties != null) {
            this.pLineProperties.setupFinished();
        } else if (this.vfLineProperties != null) {
            this.vfLineProperties.setupFinished();
        }
        if (this.pFillProperties != null) {
            this.pFillProperties.setupFinished();
        } else if (this.vfFillProperties != null) {
            this.vfFillProperties.setupFinished();
        }
        if (this.pTextureProperties != null) {
            this.pTextureProperties.setupFinished();
        } else if (this.vfTextureProperties != null) {
            this.vfTextureProperties.setupFinished();
        }
        if (this.vfTexture != null) {
            this.processImages(0, this.vfTexture);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 2;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pMaterial != null ? this.pMaterial : this.vfMaterial;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTexture != null ? this.pTexture : this.vfTexture;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTextureTransform != null ? this.pTextureTransform : this.vfTextureTransform;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pLineProperties != null ? this.pLineProperties : this.vfLineProperties;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pFillProperties != null ? this.pFillProperties : this.vfFillProperties;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pMaterial != null) {
                        vRMLNodeType.setValue(n2, this.pMaterial);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfMaterial);
                    break;
                }
                case 2: {
                    if (this.pTexture != null) {
                        vRMLNodeType.setValue(n2, this.pTexture);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfTexture);
                    break;
                }
                case 3: {
                    if (this.pTextureTransform != null) {
                        vRMLNodeType.setValue(n2, this.pTextureTransform);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfTextureTransform);
                    break;
                }
                case 4: {
                    if (this.pLineProperties != null) {
                        vRMLNodeType.setValue(n2, this.pLineProperties);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfLineProperties);
                    break;
                }
                case 6: {
                    if (this.pTextureProperties != null) {
                        vRMLNodeType.setValue(n2, this.pTextureProperties);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfTextureProperties);
                    break;
                }
                case 5: {
                    if (this.pFillProperties != null) {
                        vRMLNodeType.setValue(n2, this.pFillProperties);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfFillProperties);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 1: {
                this.setMaterial(vRMLNodeType2);
                break;
            }
            case 2: {
                this.setTexture(vRMLNodeType2);
                break;
            }
            case 3: {
                this.setTextureTransform(vRMLNodeType2);
                break;
            }
            case 4: {
                this.setLineProperties(vRMLNodeType2);
                break;
            }
            case 6: {
                this.setTextureProperties(vRMLNodeType2);
                break;
            }
            case 5: {
                this.setFillProperties(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public static float getTotalTextureSize() {
        return totalTextureSize;
    }

    protected NIOBufferImage[] processImage(int n, NIOBufferImage nIOBufferImage, String string) {
        int n2 = nIOBufferImage.getWidth();
        int n3 = nIOBufferImage.getHeight();
        if (n2 > 32 || n3 > 32) {
            if (useMipMaps && nIOBufferImage.getLevels() > 1) {
                this.stages[n].minFilter = 5;
                this.stages[n].magFilter = 3;
            }
        } else if (useMipMaps && nIOBufferImage.getLevels() > 1) {
            this.stages[n].minFilter = 4;
            this.stages[n].magFilter = 2;
        } else {
            this.stages[n].minFilter = 0;
            this.stages[n].magFilter = 0;
        }
        totalTextureSize += (float)(n2 * n3 * nIOBufferImage.getType().size / 1024) * (useMipMaps && nIOBufferImage.getLevels() > 1 ? 1.33333f : 1.0f);
        return new NIOBufferImage[]{nIOBufferImage};
    }

    protected void insureStageSize(int n, boolean bl) {
        if (n > this.stages.length) {
            int n2;
            int n3 = this.stages.length;
            TextureStage[] textureStageArray = new TextureStage[n];
            String[] stringArray = new String[n];
            for (n2 = 0; n2 < n3; ++n2) {
                textureStageArray[n2] = this.stages[n2];
                stringArray[n2] = this.urls[n2];
            }
            for (n2 = n3; n2 < n; ++n2) {
                textureStageArray[n2] = new TextureStage(n2);
            }
            this.stages = textureStageArray;
            this.urls = stringArray;
            if (bl && n > this.numStages) {
                this.numStages = n;
            }
        }
    }

    protected void processImages(int n, VRMLTextureNodeType vRMLTextureNodeType) {
        switch (vRMLTextureNodeType.getTextureType()) {
            case 0: {
                NIOBufferImage nIOBufferImage = ((VRMLTexture2DNodeType)vRMLTextureNodeType).getImage();
                if (this.urls.length >= n + 1) {
                    this.urls[n] = vRMLTextureNodeType.getCacheString(0);
                }
                if (nIOBufferImage == null) break;
                this.insureStageSize(1, true);
                this.stages[n].images = this.processImage(n, nIOBufferImage, null);
                break;
            }
            case 1: {
                VRMLComposedTextureNodeType vRMLComposedTextureNodeType = (VRMLComposedTextureNodeType)vRMLTextureNodeType;
                int n2 = vRMLComposedTextureNodeType.getNumberTextures();
                VRMLTextureNodeType[] vRMLTextureNodeTypeArray = new VRMLTextureNodeType[n2];
                vRMLComposedTextureNodeType.getTextures(0, vRMLTextureNodeTypeArray);
                this.insureStageSize(1, true);
                this.stages[n].images = new NIOBufferImage[n2];
                for (int i = 0; i < n2; ++i) {
                    NIOBufferImage nIOBufferImage = ((VRMLTexture2DNodeType)vRMLTextureNodeTypeArray[i]).getImage();
                    if (nIOBufferImage == null) continue;
                    NIOBufferImage[] nIOBufferImageArray = this.processImage(n, nIOBufferImage, null);
                    if (nIOBufferImageArray != null && nIOBufferImageArray.length != 0) {
                        this.stages[n].images[i] = nIOBufferImageArray[0];
                    }
                    this.urls[n] = null;
                }
                break;
            }
            case 2: {
                VRMLMultiTextureNodeType vRMLMultiTextureNodeType = (VRMLMultiTextureNodeType)vRMLTextureNodeType;
                int n3 = vRMLMultiTextureNodeType.getNumberTextures();
                VRMLTextureNodeType[] vRMLTextureNodeTypeArray = new VRMLTextureNodeType[n3];
                vRMLMultiTextureNodeType.getTextures(0, vRMLTextureNodeTypeArray);
                this.insureStageSize(n3, true);
                for (int i = 0; i < n3; ++i) {
                    this.processImages(i, vRMLTextureNodeTypeArray[i]);
                }
                break;
            }
        }
    }

    static {
        nodeFields = new int[]{1, 2, 3, 4, 5, 6, 0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseAppearance.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseAppearance.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "material");
        BaseAppearance.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "texture");
        BaseAppearance.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "textureTransform");
        BaseAppearance.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "lineProperties");
        BaseAppearance.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFNode", "fillProperties");
        BaseAppearance.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFNode", "textureProperties");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("material", n);
        fieldMap.put("set_material", n);
        fieldMap.put("material_changed", n);
        n = new Integer(2);
        fieldMap.put("texture", n);
        fieldMap.put("set_texture", n);
        fieldMap.put("texture_changed", n);
        n = new Integer(3);
        fieldMap.put("textureTransform", n);
        fieldMap.put("set_textureTransform", n);
        fieldMap.put("textureTransform_changed", n);
        n = new Integer(4);
        fieldMap.put("lineProperties", n);
        fieldMap.put("set_lineProperties", n);
        fieldMap.put("lineProperties_changed", n);
        n = new Integer(5);
        fieldMap.put("fillProperties", n);
        fieldMap.put("set_fillProperties", n);
        fieldMap.put("fillProperties_changed", n);
        n = new Integer(6);
        fieldMap.put("textureProperties", n);
        fieldMap.put("set_textureProperties", n);
        fieldMap.put("textureProperties_changed", n);
        useMipMaps = PropertyTools.fetchSystemProperty(USE_MIPMAPS_PROP, false);
        anisotropicDegree = PropertyTools.fetchSystemProperty(ANISOTROPIC_DEGREE_PROP, 1);
        useTextureCache = PropertyTools.fetchSystemProperty(USETEXTURECACHE_PROP, true);
    }
}

