target=oie1 oie2

\language{fr}
\format{html}
\author{Sophie Lemaire}
\email{sophie.lemaire@math.u-psud.fr}

#if #TARGET(oie2)
\title{Jeu de l'oie II}
\integer{d=random(4,6,8,12)}
\integer{n=randint(4..8)} /*nb cases*/

#elif #TARGET(oie1)

\title{Jeu de l'oie I}
\integer{d=random(4,6)}
\integer{n=randint(\d..2*\d)} 

#endif

\integer{d1=\d+1}
\integer{n1=\n-1}
\integer{o=randint(2..\n1)} /*oubliette*/

/*Matrice de transition de la chaine (sans la case oubliette)*/

#if #TARGET(oie2) 
\if{\d>\n1}
{\matrix{P=pari(d=\d;n=\n;Q=matrix(n,n,i,j,0);
for(i=1,n-1,  
  for(j=1,d, k= (j+i-1) %(n)+1 ;   Q[i,k]=Q[i,k]+ 1/d));
Q[n,n]=1;print(Q))}}
{\matrix{P=pari(d=\d;n=\n;Q=matrix(n,n,i,j,0);
for(i=1,n-1, for(j=i+1,min(i+d,n), Q[i,j]=1/d));
for(i=1,n-1,for(j=1,d-n+i,Q[i,j]=1/d));
Q[n,n]=1;print(Q))}}

#elif #TARGET(oie1)
\matrix{P=pari(d=\d;n=\n;Q=matrix(n,n,i,j,0);
for(i=1,n, for(j=i+1,min(i+d,n), Q[i,j]=1/d));
for(i=n-d,n-1,for(j=2*n-i-d,n-1,Q[i,j]=Q[i,j]+1/d));
Q[n,n]=1;print(Q))}
#endif

/* Matrice de transition de la chaine avec la case oubliette */
\matrix{Po=pari(P=[\P];d=\d;n=\n;
for(i=1,n, P[\o,i]=0);P[\o,\o]=1;print(P))}


/* Dessin du jeu */

#if #TARGET(oie2) 
\real{u=2*pi/\n}
\text{dessin=
xrange -5, 5.
yrange -5, 5
circle 0,0,90,navy
circle 0,0,30,navy }
  \for{i = 1 to \n}{ 
   \text{dessin = \dessin 
line 1.5*cos(\u*\i),1.5*sin(\u*\i),4.5*cos(\u*\i),4.5*sin(\u*\i),navy } }
\text{ dessin= \dessin
   fill 3*cos(pi/\n),3*sin(pi/\n),cyan 
   fill 3*cos(pi/\n),-3*sin(pi/\n),pink }
\for{i=1 to \n}
{\text{dessin=\dessin 
text navy, 3.5*(1-\i/60)*cos(pi*(2*\i-1)/\n),3.5*(1- \i/60)*sin(pi*(2*\i-1)/\n),small,\i }}
\text{dessin1=\dessin
    fill 3*cos((2*\o-1)*pi/\n),3*sin((2*\o-1)*pi/\n),gray }

\integer{e1=\n-1}

#elif #TARGET(oie1)

\integer{e1=\n-1}
\integer{e2=\n-2}
\integer{w=\n*25}
\text{tableau=<table align="center" border=1 cellpading=10 width=\w cellspacing=0 bgcolor=white><tr align="center">}
\text{tableau=\tableau <td> <font color=red >1 </font></td>}
\for{i=2 to (\n-1)}
{\text{tableau=\tableau <td> \i </td>}}
\text{tableau=\tableau <td> <font color=red >\n </font></td>}
\text{tableau=\tableau </tr></table>}
\text{tableau2=<table align="center" border=1 cellpading=10 width=\w cellspacing=0 bgcolor=white><tr align="center">}
\text{tableau2=\tableau2 <td> <font color=red >1 </font></td>}
\for{i=2 to (\o-1)}
{\text{tableau2=\tableau2 <td> \i </td>}}
\text{tableau2=\tableau2 <td> <font color=blue >\o </font></td>}
\for{i=(\o+1) to (\n-1)}
{\text{tableau2=\tableau2 <td> \i </td>}}
\text{tableau2=\tableau2 <td> <font color=red >\n </font></td>}
\text{tableau2=\tableau2 </tr></table>}
#endif
\text{NB=wims(record 1 of fich_rem)}
\text{pb1=wims(record 2 of fich_rem)}
\text{pb2=wims(record 3 of fich_rem)}
 \steps{reply1
reply2}

\statement{
Un jeu de l'oie simple est constitu de \n cases numrotes de 1  \n disposes comme ci-dessous. La case 1 est la case de dpart et la case \n est la case d'arrive.<p>
<center> 
#if #TARGET(oie2) 
\draw{100,100}{
\dessin}
#elif #TARGET(oie1)
\tableau
#endif
</center><p>
Pour faire avancer le pion, on lance un d  \d faces numrotes de 1
 \d et on avance le pion d'un nombre de cases gal au nombre obtenu
avec le d. Le jeu s'arrte lorsque le pion tombe exactement sur la
case \n. 
#if #TARGET(oie2) 
  Sinon le pion refait un tour. <BR>

Par exemple, si le pion se trouve sur la case \e1 et si le d tombe
sur 2, le pion va  la case 1. <p>

#elif #TARGET(oie1)
Sinon le pion recule. <BR>
 
Par exemple, si le pion se trouve sur la case \e1 et si le d tombe
sur 3, le pion va  la case \e2. Si au coup suivant, le d tombe sur
1, le pion retourne  sur la case \e1. <p>
#endif

Les positions successives du pion dfinissent une chane de Markov sur
les entiers de 1  \n. On supposera que lorsque le jeu s'arrte, les
positions suivantes du pion sont toujours \n. <p>
\if{\step>=1}{
1- Donner la matrice de transition de cette chane de Markov.<p>
<i>NB : \NB </i>}
\if{\step=2}{<p>
<font color=green> Bonne rponse : la matrice de transition de cette chane de Markov est bien :
<p>\([\P]) </font> <p>
2- Dans le vritable jeu de l'oie, toutes les cases ne sont pas
identiques. On modifie le plateau du jeu en supposant que la case \o
est une case "oubliette", ce qui signifie que si le pion tombe sur
cette case, il y reste indfiniment. 
<center> 
#if #TARGET(oie2)
\draw{100,100}{
\dessin1}
#elif #TARGET(oie1)
\tableau2
#endif
</center><p>
Dterminer la matrice de transition de la chane de Markov qui dcrit
les positions successsives du pion sur ce nouveau plateau.
}
}
\answer{Matrice de transition}{\P}{type=matrix}
\answer{Matrice de transition}{\Po}{type=matrix}

\matrix{PR1=[\reply1]};
\text{verif=wims(record 0 of progverif)} 
\matrix{nv1=pari(\verif;matstoch(\PR1,\n,\n))}
\matrix{PR2=[\reply2]};
\matrix{nv2=pari(\verif;matstoch(\PR2,\n,\n))}

\feedback{\step=1 and \nv1[1]=1}{<font color=red> \pb1 </font>}
\feedback{\step=1 and \nv1[1]=0 and \nv1[2]=1}{<font color=red> \pb2 </font>}
\feedback{\step=1}{<font color=green> La matrice de transition de la chane de Markov  est : \([\P])</font>}
\feedback{\step=2 and \nv2[1]=1}{<font color=IndianRed> \pb1 </font>}
\feedback{\step=2 and \nv2[1]=0 and \nv2[2]=1}{<font color=IndianRed> \pb2 </font>}
\feedback{\step=2}{<font color=green> La matrice de transition de la chane de Markov pour le deuxime plateau de jeu est : \([\Po])</font>}