/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.utils;

import java.io.Serializable;

public class ByteVector
implements Serializable {
    protected byte[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public ByteVector(int n, int n2) {
        this.elementData = new byte[n];
        this.capacityIncrement = n2;
    }

    public ByteVector(int n) {
        this(n, 5);
    }

    public ByteVector() {
        this(10);
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            byte[] byArray = this.elementData;
            this.elementData = new byte[this.elementCount];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(byte by) {
        return this.indexOf(by, 0) >= 0;
    }

    public final int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    public final synchronized int indexOf(byte by, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (by != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized byte elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized void addElement(byte by) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = by;
    }

    public final synchronized void addElements(byte[] byArray) {
        if (byArray != null) {
            this.ensureCapacity(this.elementCount + byArray.length);
            System.arraycopy(byArray, 0, this.elementData, this.elementCount, byArray.length);
            this.elementCount += byArray.length;
        } else {
            throw new NullPointerException("Try to add null elements");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void addElements(byte[] byArray, int n) {
        if (byArray == null) throw new NullPointerException("Try to add null elements");
        if (n <= 0 || n > byArray.length) throw new IllegalArgumentException("Invalid length argument : " + n);
        this.ensureCapacity(this.elementCount + byArray.length);
        System.arraycopy(byArray, 0, this.elementData, this.elementCount, n);
        this.elementCount += n;
    }

    public final synchronized boolean removeElement(byte by) {
        int n = this.indexOf(by);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public final synchronized void removeAllElements() {
        this.elementCount = 0;
        this.elementData = new byte[this.capacityIncrement];
    }

    public final synchronized byte[] getBytes() {
        this.trimToSize();
        return this.elementData;
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            byte[] byArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new byte[n3];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized String toString() {
        String string = " [ ";
        for (int i = 0; i < this.elementCount; ++i) {
            string = string + this.elementData[i] + " ";
        }
        string = string + "]";
        return string;
    }
}

